/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget;

import android.content.Context;
import android.text.method.ScrollingMovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.appcompat.widget.AppCompatTextView;

public class ScrollTextView
extends AppCompatTextView {
    float lastScrollY = 0.0f;

    public ScrollTextView(Context context) {
        super(context);
        this.setMovementMethod(ScrollingMovementMethod.getInstance());
    }

    public ScrollTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setMovementMethod(ScrollingMovementMethod.getInstance());
    }

    public ScrollTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setMovementMethod(ScrollingMovementMethod.getInstance());
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.getLineCount() > this.getMaxLines()) {
            if (ev.getAction() == 0) {
                this.lastScrollY = ev.getRawY();
            } else if (ev.getAction() == 2) {
                int sum = this.getLineHeight() * this.getLineCount() - this.getLineHeight() * this.getMaxLines();
                float diff = this.lastScrollY - ev.getRawY();
                if (diff > 0.0f) {
                    if (Math.abs(sum - this.getScrollY()) < 5) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    } else {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                } else if (diff < 0.0f) {
                    if (this.getScrollY() == 0) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    } else {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                }
                this.lastScrollY = ev.getRawY();
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.onTouchEvent(ev);
    }
}

