/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.discreteSeekBar.internal.compat;

import android.os.Build;
import com.lyy.keepassa.widget.discreteSeekBar.internal.compat.AnimatorCompatV11;

public abstract class AnimatorCompat {
    AnimatorCompat() {
    }

    public abstract void cancel();

    public abstract boolean isRunning();

    public abstract void setDuration(int var1);

    public abstract void start();

    public static final AnimatorCompat create(float start, float end, AnimationFrameUpdateListener listener) {
        if (Build.VERSION.SDK_INT >= 11) {
            return new AnimatorCompatV11(start, end, listener);
        }
        return new AnimatorCompatBase(start, end, listener);
    }

    private static class AnimatorCompatBase
    extends AnimatorCompat {
        private final AnimationFrameUpdateListener mListener;
        private final float mEndValue;

        public AnimatorCompatBase(float start, float end, AnimationFrameUpdateListener listener) {
            this.mListener = listener;
            this.mEndValue = end;
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public void setDuration(int progressAnimationDuration) {
        }

        @Override
        public void start() {
            this.mListener.onAnimationFrame(this.mEndValue);
        }
    }

    public static interface AnimationFrameUpdateListener {
        public void onAnimationFrame(float var1);
    }
}

