/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.discreteSeekBar.internal.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import com.lyy.keepassa.widget.discreteSeekBar.internal.drawable.StateDrawable;

public class AlmostRippleDrawable
extends StateDrawable
implements Animatable {
    private static final long FRAME_DURATION = 16L;
    private static final int ANIMATION_DURATION = 250;
    private static final float INACTIVE_SCALE = 0.0f;
    private static final float ACTIVE_SCALE = 1.0f;
    private float mCurrentScale = 0.0f;
    private Interpolator mInterpolator;
    private long mStartTime;
    private boolean mReverse = false;
    private boolean mRunning = false;
    private int mDuration = 250;
    private float mAnimationInitialValue;
    private int mPressedColor;
    private int mFocusedColor;
    private int mDisabledColor;
    private int mRippleColor;
    private int mRippleBgColor;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            long currentTime = SystemClock.uptimeMillis();
            long diff = currentTime - AlmostRippleDrawable.this.mStartTime;
            if (diff < (long)AlmostRippleDrawable.this.mDuration) {
                float interpolation = AlmostRippleDrawable.this.mInterpolator.getInterpolation((float)diff / (float)AlmostRippleDrawable.this.mDuration);
                AlmostRippleDrawable.this.scheduleSelf(AlmostRippleDrawable.this.mUpdater, currentTime + 16L);
                AlmostRippleDrawable.this.updateAnimation(interpolation);
            } else {
                AlmostRippleDrawable.this.unscheduleSelf(AlmostRippleDrawable.this.mUpdater);
                AlmostRippleDrawable.this.mRunning = false;
                AlmostRippleDrawable.this.updateAnimation(1.0f);
            }
        }
    };

    public AlmostRippleDrawable(@NonNull ColorStateList tintStateList) {
        super(tintStateList);
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.setColor(tintStateList);
    }

    public void setColor(@NonNull ColorStateList tintStateList) {
        int defaultColor = tintStateList.getDefaultColor();
        this.mFocusedColor = tintStateList.getColorForState(new int[]{16842910, 16842908}, defaultColor);
        this.mPressedColor = tintStateList.getColorForState(new int[]{16842910, 16842919}, defaultColor);
        this.mDisabledColor = tintStateList.getColorForState(new int[]{-16842910}, defaultColor);
        this.mFocusedColor = AlmostRippleDrawable.getModulatedAlphaColor(130, this.mFocusedColor);
        this.mPressedColor = AlmostRippleDrawable.getModulatedAlphaColor(130, this.mPressedColor);
        this.mDisabledColor = AlmostRippleDrawable.getModulatedAlphaColor(130, this.mDisabledColor);
    }

    private static int getModulatedAlphaColor(int alphaValue, int originalColor) {
        int alpha = Color.alpha((int)originalColor);
        int scale = alphaValue + (alphaValue >> 7);
        alpha = alpha * scale >> 8;
        return Color.argb((int)alpha, (int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor));
    }

    @Override
    public void doDraw(Canvas canvas, Paint paint) {
        Rect bounds = this.getBounds();
        int size = Math.min(bounds.width(), bounds.height());
        float scale = this.mCurrentScale;
        int rippleColor = this.mRippleColor;
        int bgColor = this.mRippleBgColor;
        float radius = size / 2;
        float radiusAnimated = radius * scale;
        if (scale > 0.0f) {
            if (bgColor != 0) {
                paint.setColor(bgColor);
                paint.setAlpha(this.decreasedAlpha(Color.alpha((int)bgColor)));
                canvas.drawCircle((float)bounds.centerX(), (float)bounds.centerY(), radius, paint);
            }
            if (rippleColor != 0) {
                paint.setColor(rippleColor);
                paint.setAlpha(this.modulateAlpha(Color.alpha((int)rippleColor)));
                canvas.drawCircle((float)bounds.centerX(), (float)bounds.centerY(), radiusAnimated, paint);
            }
        }
    }

    private int decreasedAlpha(int alpha) {
        int scale = 100;
        return alpha * scale >> 8;
    }

    @Override
    public boolean setState(int[] stateSet) {
        int[] oldState = this.getState();
        boolean oldPressed = false;
        for (int i : oldState) {
            if (i != 16842919) continue;
            oldPressed = true;
        }
        super.setState(stateSet);
        boolean focused = false;
        boolean pressed = false;
        boolean disabled = true;
        for (int i : stateSet) {
            if (i == 16842908) {
                focused = true;
                continue;
            }
            if (i == 16842919) {
                pressed = true;
                continue;
            }
            if (i != 16842910) continue;
            disabled = false;
        }
        if (disabled) {
            this.unscheduleSelf(this.mUpdater);
            this.mRippleColor = this.mDisabledColor;
            this.mRippleBgColor = 0;
            this.mCurrentScale = 0.5f;
            this.invalidateSelf();
        } else if (pressed) {
            this.animateToPressed();
            this.mRippleColor = this.mRippleBgColor = this.mPressedColor;
        } else if (oldPressed) {
            this.mRippleColor = this.mRippleBgColor = this.mPressedColor;
            this.animateToNormal();
        } else if (focused) {
            this.mRippleColor = this.mFocusedColor;
            this.mRippleBgColor = 0;
            this.mCurrentScale = 1.0f;
            this.invalidateSelf();
        } else {
            this.mRippleColor = 0;
            this.mRippleBgColor = 0;
            this.mCurrentScale = 0.0f;
            this.invalidateSelf();
        }
        return true;
    }

    public void animateToPressed() {
        this.unscheduleSelf(this.mUpdater);
        if (this.mCurrentScale < 1.0f) {
            this.mReverse = false;
            this.mRunning = true;
            this.mAnimationInitialValue = this.mCurrentScale;
            float durationFactor = 1.0f - (this.mAnimationInitialValue - 0.0f) / 1.0f;
            this.mDuration = (int)(250.0f * durationFactor);
            this.mStartTime = SystemClock.uptimeMillis();
            this.scheduleSelf(this.mUpdater, this.mStartTime + 16L);
        }
    }

    public void animateToNormal() {
        this.unscheduleSelf(this.mUpdater);
        if (this.mCurrentScale > 0.0f) {
            this.mReverse = true;
            this.mRunning = true;
            this.mAnimationInitialValue = this.mCurrentScale;
            float durationFactor = 1.0f - (this.mAnimationInitialValue - 1.0f) / -1.0f;
            this.mDuration = (int)(250.0f * durationFactor);
            this.mStartTime = SystemClock.uptimeMillis();
            this.scheduleSelf(this.mUpdater, this.mStartTime + 16L);
        }
    }

    private void updateAnimation(float factor) {
        float initial = this.mAnimationInitialValue;
        float destination = this.mReverse ? 0.0f : 1.0f;
        this.mCurrentScale = initial + (destination - initial) * factor;
        this.invalidateSelf();
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return this.mRunning;
    }
}

