/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.editor;

import android.text.Editable;
import android.util.Log;
import com.lyy.keepassa.widget.editor.ActionManager;
import com.lyy.keepassa.widget.editor.AddAction;
import com.lyy.keepassa.widget.editor.ClearAction;
import com.lyy.keepassa.widget.editor.DeleteAction;
import com.lyy.keepassa.widget.editor.IAction;
import com.lyy.keepassa.widget.editor.StringWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0006J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\rR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/lyy/keepassa/widget/editor/OperateManager;", "", "ed", "Landroid/text/Editable;", "(Landroid/text/Editable;)V", "TAG", "", "kotlin.jvm.PlatformType", "actionManager", "Lcom/lyy/keepassa/widget/editor/ActionManager;", "getEd", "()Landroid/text/Editable;", "add", "", "addStr", "start", "", "clear", "delete", "delStr", "end", "destroy", "redo", "undo", "UIWidget_debug"})
public final class OperateManager {
    @NotNull
    private final Editable ed;
    private final String TAG;
    @NotNull
    private final ActionManager actionManager;

    public OperateManager(@NotNull Editable ed) {
        Intrinsics.checkNotNullParameter((Object)ed, (String)"ed");
        this.ed = ed;
        this.TAG = this.getClass().getSimpleName();
        this.actionManager = new ActionManager();
    }

    @NotNull
    public final Editable getEd() {
        return this.ed;
    }

    public final void destroy() {
        this.actionManager.getRedoQueue().clear();
        this.actionManager.getUndoQueue().clear();
    }

    public final void add(@NotNull String addStr, int start) {
        Intrinsics.checkNotNullParameter((Object)addStr, (String)"addStr");
        Log.d((String)this.TAG, (String)("AddAction, content = " + addStr + ", start = " + start));
        AddAction addAction = new AddAction(this.ed, new StringWrapper(1, addStr, start));
        this.actionManager.setLastAction(addAction);
    }

    public final void delete(@NotNull String delStr, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)delStr, (String)"delStr");
        Log.d((String)this.TAG, (String)("delAction, content = " + delStr + ", start = " + start));
        DeleteAction delAction = new DeleteAction(this.ed, new StringWrapper(2, delStr, start));
        this.actionManager.setLastAction(delAction);
    }

    @NotNull
    public final String clear() {
        String string = this.ed.toString();
        ClearAction clearAction = new ClearAction(this.ed, new StringWrapper(3, string, 0));
        this.actionManager.setLastAction(clearAction);
        return "";
    }

    public final void undo() {
        if (this.actionManager.canUndo()) {
            IAction action = this.actionManager.undo();
            Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"undoAction, actionType = ", (Object)action));
            IAction iAction = action;
            if (iAction != null) {
                iAction.undo();
            }
        }
    }

    public final void redo() {
        if (this.actionManager.canRedo()) {
            IAction action = this.actionManager.redo();
            Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"redoAction, actionType = ", (Object)action));
            IAction iAction = action;
            if (iAction != null) {
                iAction.redo();
            }
        }
    }
}

