package com.lyy.keepassa.widget

import android.animation.ValueAnimator
import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.Paint.Cap.ROUND
import android.graphics.Paint.Style.STROKE
import android.util.AttributeSet
import android.view.animation.LinearInterpolator
import android.widget.ProgressBar
import androidx.core.animation.doOnRepeat
import androidx.core.content.withStyledAttributes
import com.example.uiwidget.R

/**
 * @Author laoyuyu
 * @Description
 * @Date 1:57 下午 2022/1/5
 **/
class CountdownView(context: Context, attributeSet: AttributeSet) :
  ProgressBar(context, attributeSet, android.R.style.Widget_ProgressBar_Horizontal) {

  private var mMaxPaintWidth = 0
  private var mRadius: Int = 30
  private val mPaint = Paint()
  private var unChangeColor = Color.BLUE
  private var reachedColor = Color.RED
  private var diameter = 0f
  private var countdownTime = 30
  private var animation: ValueAnimator? = null

  init {
    mPaint.style = STROKE
    mPaint.isAntiAlias = true
    mPaint.isDither = true
    mPaint.strokeCap = ROUND
    mPaint.isAntiAlias = true
    mPaint.style = Paint.Style.FILL_AND_STROKE

    context.withStyledAttributes(attributeSet, R.styleable.CountdownView) {
      unChangeColor = getColor(R.styleable.CountdownView_cv_bar_unreached_color, Color.BLUE)
      reachedColor = getColor(R.styleable.CountdownView_cv_bar_reached_color, Color.RED)
      countdownTime = getInteger(R.styleable.CountdownView_cv_bar_time, 30)
    }
    max = countdownTime
    progress = 0
  }

  override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
    super.onMeasure(widthMeasureSpec, heightMeasureSpec)
    val expect: Int = (mRadius * 2 + mMaxPaintWidth + paddingLeft
      + paddingRight)
    val width = resolveSize(expect, widthMeasureSpec)
    val height = resolveSize(expect, heightMeasureSpec)
    val realWidth = Math.min(width, height)

    mRadius = (realWidth - paddingLeft - paddingRight - mMaxPaintWidth) / 2
    diameter = mRadius * 2f
    setMeasuredDimension(realWidth, realWidth)
  }

  override fun onDetachedFromWindow() {
    super.onDetachedFromWindow()
    animation?.cancel()
  }

  fun startAnim(loop: Boolean = true, onRepeat: () -> Unit) {
    animation = ValueAnimator.ofInt(0, countdownTime)
    animation?.let {
      it.addUpdateListener { animObj ->
        val p = animObj.animatedValue as Int
        if (p != progress) {
          progress = p
        }
      }
      it.doOnRepeat {
        onRepeat.invoke()
      }
      it.interpolator = LinearInterpolator()
      it.duration = countdownTime * 1000L
      it.repeatCount = if (loop) ValueAnimator.INFINITE else 0
      it.repeatMode = ValueAnimator.RESTART
      it.start()
    }
  }

  override fun onDraw(canvas: Canvas) {
    canvas.save()
    val angle = (progress.toFloat() / max) * 360f
    mPaint.color = reachedColor
    canvas.drawArc(0f, 0f, diameter, diameter, 270f, angle, true, mPaint)
    mPaint.color = unChangeColor
    canvas.drawArc(0f, 0f, diameter, diameter, 270f + angle, 360 - angle, true, mPaint)
    canvas.restore()
  }
}