/*
 * Copyright (C) 2020 AriaLyy(https://github.com/AriaLyy/KeepassA)
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at http://mozilla.org/MPL/2.0/.
 */


package com.lyy.keepassa.widget

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.content.Context
import android.util.AttributeSet
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.animation.AccelerateDecelerateInterpolator
import android.view.animation.AnticipateOvershootInterpolator
import android.view.animation.LinearInterpolator
import android.widget.FrameLayout
import androidx.appcompat.widget.AppCompatImageButton
import com.example.uiwidget.R
import com.google.android.material.floatingactionbutton.FloatingActionButton

class MainExpandFloatActionButton(
  context: Context,
  attributeSet: AttributeSet
) : FrameLayout(context, attributeSet), View.OnClickListener {
  private val TAG = javaClass.simpleName

  private val DEF_VIEW_SIZE = 56.toPx()
  private val INTERVAL = 16.toPx()
  private var fab: FloatingActionButton
  private var addKey: AppCompatImageButton
  private var addGroup: AppCompatImageButton
  private var animIsRunning = false
  private var itemListener: OnItemClickListener? = null
  public var isShowOperate = false

  interface OnItemClickListener {
    fun onKeyClick()

    fun onGroupClick()
  }

  init {
    LayoutInflater.from(context)
        .inflate(R.layout.layout_expadn_float_action_bt, this, true)
    fab = findViewById(R.id.ex_fab)
    addKey = findViewById(R.id.add_key)
    addGroup = findViewById(R.id.add_group)
    fab.setOnClickListener(this)
    addKey.setOnClickListener(this)
    addGroup.setOnClickListener(this)
  }

  fun setOnItemClickListener(listener: OnItemClickListener) {
    this.itemListener = listener
  }

  /**
   * fab 按钮的操作
   */
  fun showMoreOperate() {
    animIsRunning = true
    isShowOperate = true
    addKey.visibility = View.VISIBLE
    addGroup.visibility = View.VISIBLE

    val startX = width - DEF_VIEW_SIZE
    val endX = width - DEF_VIEW_SIZE * 2 - INTERVAL

    val valueAnimator = ValueAnimator.ofInt(startX, endX)
        .setDuration(400)
    valueAnimator.addUpdateListener {
      val value = (it.animatedValue as Int).toFloat()
      addKey.x = value
      addGroup.y = value
      val percent = endX / value
      addKey.alpha = percent
      addGroup.alpha = percent
    }

    valueAnimator.interpolator = AccelerateDecelerateInterpolator()
    valueAnimator.addListener(object : AnimatorListenerAdapter() {
      override fun onAnimationEnd(animation: Animator?) {
        super.onAnimationEnd(animation)
        animIsRunning = false
      }
    })
    valueAnimator.start()
    val fabAnim = ObjectAnimator.ofFloat(fab, "rotation", 0f, 45f)
    fabAnim.duration = 200
    fabAnim.interpolator = AnticipateOvershootInterpolator()
    fabAnim.start()
  }

  fun hintMoreOperateNoAnim() {
    addKey.visibility = View.GONE
    addGroup.visibility = View.GONE
    fab.rotation = 0f
    isShowOperate = false
  }

  /**
   * 隐藏fab 的更多操作
   */
  fun hintMoreOperate() {
    animIsRunning = true
    isShowOperate = false


    val w = resources.getDimension(R.dimen.fab_bt_size)
        .toInt()
    addKey.layoutParams.width = w
    addKey.layoutParams.height = w
    addGroup.layoutParams.width = w
    addGroup.layoutParams.height = w

    val startX = width - DEF_VIEW_SIZE * 2 - INTERVAL
    val endX = width - DEF_VIEW_SIZE

    val valueAnimator = ValueAnimator.ofInt(startX, endX)
        .setDuration(400)

    addKey.visibility = View.VISIBLE
    valueAnimator.addUpdateListener {
      addKey.x = ((it.animatedValue as Int).toFloat())
      val value = (it.animatedValue as Int).toFloat()
      addKey.x = value
      addGroup.y = value
      val percent = endX / value
      addKey.alpha = percent
      addGroup.alpha = percent
    }

    valueAnimator.interpolator = AccelerateDecelerateInterpolator()
    valueAnimator.addListener(object : AnimatorListenerAdapter() {
      override fun onAnimationEnd(animation: Animator?) {
        super.onAnimationEnd(animation)
        animIsRunning = false
        addKey.visibility = View.GONE
        addGroup.visibility = View.GONE
      }
    })
    valueAnimator.start()

    val fabAnim = ObjectAnimator.ofFloat(fab, "rotation", 45f, 0f)
    fabAnim.duration = 200
    fabAnim.interpolator = AnticipateOvershootInterpolator()
    fabAnim.start()
  }

  override fun onClick(v: View?) {
    when (v!!.id) {
      R.id.ex_fab -> {
        if (animIsRunning) {
          return
        }
        if (isShowOperate) {
          hintMoreOperate()
        } else {
          showMoreOperate()
        }
      }
      R.id.add_key -> itemListener?.onKeyClick()
      R.id.add_group -> itemListener?.onGroupClick()
    }
  }

}