/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.helicopterorm;

import com.heliorm.Orm;
import com.heliorm.OrmException;
import com.heliorm.sql.mysql.MySqlDriver;
import com.heliorm.sql.postgres.PostgreSqlDriver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import me.legrange.service.Component;
import me.legrange.service.ComponentException;
import me.legrange.service.Service;
import me.legrange.services.helicopterorm.HeliOrmConfig;
import me.legrange.services.helicopterorm.OrmPool;
import me.legrange.services.helicopterorm.ProxyOrm;
import me.legrange.services.jdbc.ConnectionPoolException;
import me.legrange.services.jdbc.JdbcComponent;
import me.legrange.services.jdbc.WithJdbc;

public final class HeliOrmComponent
extends Component<Service, HeliOrmConfig>
implements WithJdbc {
    private OrmPool pool;

    public HeliOrmComponent(Service service) {
        super(service);
    }

    public void start(HeliOrmConfig config) throws ComponentException {
        try {
            String dialect;
            this.pool = new OrmPool(this.jdbc(), switch (dialect = ((JdbcComponent)this.getComponent(JdbcComponent.class)).getDialect()) {
                case "MYSQL" -> MySqlDriver.class;
                case "POSTGRESQL" -> PostgreSqlDriver.class;
                default -> throw new ComponentException(String.format("Unsupported driver type '%s'", dialect));
            }, config);
        }
        catch (OrmException | ConnectionPoolException ex) {
            throw new ComponentException(ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ComponentException("Invalid SQL dialect", (Throwable)ex);
        }
    }

    public void stop() {
        this.pool.close();
    }

    public Orm getInstance() {
        return (Orm)Proxy.newProxyInstance(HeliOrmComponent.class.getClassLoader(), new Class[]{Orm.class}, (InvocationHandler)new ProxyOrm(this.pool));
    }

    public String getName() {
        return "orm";
    }
}

