/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.helicopterorm;

import com.heliorm.Orm;
import com.heliorm.OrmException;
import com.heliorm.sql.SqlDriver;
import com.heliorm.sql.SqlOrmBuilder;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import me.legrange.log.Log;
import me.legrange.services.helicopterorm.HeliOrmConfig;
import me.legrange.services.jdbc.ConnectionPool;

final class OrmPool {
    private final int MAX_POOL_SIZE = 16;
    private final int MIN_POOL_SIZE = 4;
    private final List<Orm> available = new LinkedList<Orm>();
    private final Set<Orm> inUse = new HashSet<Orm>();
    private final HeliOrmConfig config;
    private final ConnectionPool pool;
    private final Class<? extends SqlDriver> driverClass;

    OrmPool(ConnectionPool pool, Class<? extends SqlDriver> driverClass, HeliOrmConfig config) throws OrmException {
        this.pool = pool;
        this.config = config;
        this.driverClass = driverClass;
        for (int i = 0; i < 4; ++i) {
            this.available.add(this.createOrm());
        }
    }

    synchronized Orm issue() throws OrmException {
        if (this.available.isEmpty()) {
            if (this.inUse.size() >= 16) {
                throw new OrmException(String.format("ORM pool (%s) exhausted", 16));
            }
            this.available.add(this.createOrm());
        }
        Orm orm = this.available.removeFirst();
        this.inUse.add(orm);
        Log.debug(() -> String.format("pool[issue]: available = %d, in use = %d", this.available.size(), this.inUse.size()));
        return orm;
    }

    void close() {
    }

    synchronized void release(Orm orm) {
        this.inUse.remove(orm);
        this.available.add(orm);
        while (this.available.size() > 4) {
            this.available.removeFirst().close();
        }
        Log.debug(() -> String.format("pool[release]: available = %d, in use = %d", this.available.size(), this.inUse.size()));
    }

    private Orm createOrm() throws OrmException {
        return SqlOrmBuilder.create(() -> ((ConnectionPool)this.pool).getConnection(), this.driverClass).setCreateMissingTables(this.config.isCreateMissingTables()).setRollbackOnUncommittedClose(this.config.isRollbackOnUncommittedClose()).setUseUnionAll(this.config.isUseUnionAll()).build();
    }
}

