/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.jetty;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import me.legrange.log.Log;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GsonJerseyProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final String UTF_8 = "UTF-8";
    private Gson gson;

    protected Gson getGson() {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls().setPrettyPrinting().enableComplexMapKeySerialization();
            this.gson = builder.create();
            Log.debug((String)"GsonJerseyProvider created", (Object[])new Object[0]);
        }
        return this.gson;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try (InputStreamReader streamReader = new InputStreamReader(entityStream, UTF_8);){
            Object object = this.getGson().fromJson((Reader)streamReader, genericType);
            return object;
        }
        return null;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, UTF_8);){
            this.getGson().toJson(object, genericType, (Appendable)writer);
        }
    }
}

