/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.jetty;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.legrange.log.Log;
import me.legrange.service.Component;
import me.legrange.service.ComponentException;
import me.legrange.service.Service;
import me.legrange.services.jetty.ErrorFilter;
import me.legrange.services.jetty.GsonJerseyProvider;
import me.legrange.services.jetty.JettyConfig;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JettyComponent
extends Component<Service<?>, JettyConfig> {
    private Server server;
    private ServletContextHandler context;
    private boolean running = false;
    private final List<Object> jerseyProviders = new ArrayList<Object>();
    private final Map<String, Set<Class<?>>> endpoints = new HashMap();
    private JettyConfig config;

    public JettyComponent(Service<?> service) {
        super(service);
    }

    public String getName() {
        return "jetty";
    }

    public void start(JettyConfig config) throws ComponentException {
        this.config = config;
        if (config.isEnabled()) {
            try {
                this.context = this.makeContext();
                this.server = new Server(config.getPort());
                this.server.setHandler(this.gzip((Handler)this.context));
                this.server.start();
                Log.info((String)"Started Jetty server on port %d", (Object[])new Object[]{config.getPort()});
            }
            catch (Exception ex) {
                throw new ComponentException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            Log.warning((String)"Jetty server disabled", (Object[])new Object[0]);
        }
    }

    public void stop() throws ComponentException {
        if (this.config.isEnabled()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new ComponentException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addEndpoints(String path, Set<Class<?>> endpoints) throws ComponentException {
        ResourceConfig rc = new ResourceConfig(endpoints);
        rc.addProperties(Collections.singletonMap("jersey.config.server.wadl.disableWadl", "true"));
        rc.addProperties(Collections.singletonMap("jersey.config.server.contentLength.buffer", 0));
        for (Object provider : this.jerseyProviders) {
            rc.register(provider);
        }
        ServletHolder holder = new ServletHolder((Servlet)new ServletContainer(rc));
        this.context.addServlet(holder, path + "/*");
        try {
            this.context.start();
        }
        catch (Exception ex) {
            throw new ComponentException(ex.getMessage(), (Throwable)ex);
        }
        if (this.endpoints.containsKey(path)) {
            Log.info((String)"Re-added %d endpoints on path %s", (Object[])new Object[]{endpoints.size(), path});
        } else {
            Log.info((String)"Added %d new endpoint of type  on path %s", (Object[])new Object[]{endpoints.size(), path});
            this.endpoints.put(path, endpoints);
        }
        this.running = true;
        this.checkForMessageBodyWriter();
    }

    public void addEndpoint(String path, Class<?> endpoint) throws ComponentException {
        ResourceConfig rc = new ResourceConfig(new Class[]{endpoint});
        this.checkForMessageBodyWriter();
        for (Object provider : this.jerseyProviders) {
            rc.register(provider);
        }
        ServletHolder holder = new ServletHolder((Servlet)new ServletContainer(rc));
        this.context.addServlet(holder, path + "/*");
        try {
            this.context.start();
        }
        catch (Exception ex) {
            throw new ComponentException(ex.getMessage(), (Throwable)ex);
        }
        if (this.endpoints.containsKey(path)) {
            Log.info((String)"Re-added endpoint of type '%s' on '%s'", (Object[])new Object[]{endpoint.getSimpleName(), path});
        } else {
            Log.info((String)"Added new endpoint of type '%s' on '%s'", (Object[])new Object[]{endpoint.getSimpleName(), path});
            this.endpoints.put(path, Collections.singleton(endpoint));
        }
        this.running = true;
    }

    public void addProvider(Class<?> provider) throws ComponentException {
        try {
            this.addProvider(provider.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ComponentException(String.format("No default constructor for provider class %s. Either pass an instance or a provider with a default constructor", provider.getSimpleName()), (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ComponentException(String.format("Error creating provider from class %s (%s)", provider.getSimpleName(), e.getMessage()), (Throwable)e);
        }
    }

    public void addProvider(Object provider) throws ComponentException {
        Optional<MessageBodyWriter<?>> mbr;
        if (provider instanceof MessageBodyWriter && (mbr = this.findMessageBodyWriter()).isPresent() && mbr.get() instanceof GsonJerseyProvider) {
            this.jerseyProviders.remove(mbr.get());
            Log.warning((String)"Replacing message body writer '%s' with '%s'", (Object[])new Object[]{mbr.get().getClass().getSimpleName(), provider.getClass().getName()});
        }
        this.jerseyProviders.add(provider);
        if (this.running) {
            Log.info((String)"Re-adding %d endpoint(s) because of provider change", (Object[])new Object[]{this.endpoints.size()});
            this.context = this.makeContext();
            try {
                this.server.stop();
                this.server.setHandler(this.gzip((Handler)this.context));
                this.server.start();
            }
            catch (Exception ex) {
                throw new ComponentException(ex.getMessage(), (Throwable)ex);
            }
            for (Map.Entry<String, Set<Class<?>>> pair : this.endpoints.entrySet()) {
                this.addEndpoints(pair.getKey(), pair.getValue());
            }
        }
    }

    private void checkForMessageBodyWriter() throws ComponentException {
        if (this.findMessageBodyWriter().isEmpty()) {
            throw new ComponentException("No MessageBodyWriters were registered for serialization. Remember to register them using the addProvider methods");
        }
    }

    private Optional<? extends MessageBodyWriter<?>> findMessageBodyWriter() {
        return this.jerseyProviders.stream().filter(MessageBodyWriter.class::isInstance).map(p -> (MessageBodyWriter)p).findFirst();
    }

    private ServletContextHandler makeContext() {
        this.context = new ServletContextHandler(1);
        this.context.setContextPath("/");
        if (this.config.isStandardErrorFilter()) {
            this.context.addFilter(ErrorFilter.class, "/*", EnumSet.of(DispatcherType.ERROR));
        }
        return this.context;
    }

    private Handler gzip(Handler context) {
        if (this.config.isEnableGzip()) {
            GzipHandler handler = new GzipHandler();
            handler.setIncludedMethods(new String[]{"PUT", "POST", "GET"});
            handler.setInflateBufferSize(2048);
            handler.setHandler(context);
            return handler;
        }
        return context;
    }
}

