/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.jetty;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import me.legrange.log.Log;

public final class ErrorFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        Log.info((String)"ErrorFilter", (Object[])new Object[0]);
        try {
            fc.doFilter(req, res);
        }
        catch (ServletException ex) {
            if (ex.getCause() != null) {
                Log.error((Throwable)ex.getCause(), (String)"Unhandled exception in REST endpoint: %s", (Object[])new Object[]{ex.getCause()});
            } else {
                Log.error((Throwable)ex, (String)"Unhandled exception in REST endpoint: %s", (Object[])new Object[]{ex.getMessage()});
            }
            throw ex;
        }
        catch (IOException ex) {
            Log.error((Throwable)ex, (String)"IO error (%s)", (Object[])new Object[]{ex.getMessage(), ex});
            throw ex;
        }
        catch (Exception ex) {
            Log.error((Throwable)ex, (String)"Unexpected error (%s)", (Object[])new Object[]{ex.getMessage(), ex});
            throw new ServletException(ex.getMessage(), (Throwable)ex);
        }
    }
}

