/*
 * Decompiled with CFR 0.152.
 */
package me.lemonypancakes.resourcemanagerhelper.impl.v1_19_R1;

import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.lemonypancakes.resourcemanagerhelper.Resource;
import me.lemonypancakes.resourcemanagerhelper.ResourceLocation;
import me.lemonypancakes.resourcemanagerhelper.ResourceManager;
import me.lemonypancakes.resourcemanagerhelper.impl.v1_19_R1.NMSResource;
import me.lemonypancakes.resourcemanagerhelper.impl.v1_19_R1.NMSResourceLocation;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;

public final class NMSResourceManager
implements ResourceManager {
    @Nonnull
    private final net.minecraft.server.packs.resources.ResourceManager handle;

    public NMSResourceManager() {
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedServer = craftServer.getServer();
        this.handle = dedicatedServer.getResourceManager();
    }

    @Nonnull
    public Map<ResourceLocation, Resource> listResources(@Nonnull String resourceFolder, @Nonnull Predicate<ResourceLocation> resourceLocationPredicate) {
        return this.handle.listResources(resourceFolder, resourceLocation -> resourceLocationPredicate.test(new NMSResourceLocation((net.minecraft.resources.ResourceLocation)resourceLocation))).entrySet().stream().collect(Collectors.toMap(entry -> new NMSResourceLocation((net.minecraft.resources.ResourceLocation)entry.getKey()), entry -> new NMSResource((net.minecraft.server.packs.resources.Resource)entry.getValue())));
    }

    @Nonnull
    public net.minecraft.server.packs.resources.ResourceManager getHandle() {
        return this.handle;
    }
}

