/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.sk8s;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import me.lightspeed7.sk8s.AppInfo;
import me.lightspeed7.sk8s.ApplicationInfo;
import me.lightspeed7.sk8s.ApplicationInfo$;
import me.lightspeed7.sk8s.JsonResult;
import me.lightspeed7.sk8s.MessageResponse;
import me.lightspeed7.sk8s.MessageResponse$;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.OFormat;
import play.api.libs.json.OFormat$;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.Result;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JsonResult$
implements LazyLogging,
scala.Serializable {
    public static JsonResult$ MODULE$;
    private final OFormat<JsonResult> _format;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JsonResult$();
    }

    private Logger logger$lzycompute() {
        JsonResult$ jsonResult$ = this;
        synchronized (jsonResult$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public OFormat<JsonResult> _format() {
        return this._format;
    }

    private JsValue toEmpty(String in, String reason) {
        return Json$.MODULE$.toJson((Object)new MessageResponse(reason, (String)Option$.MODULE$.apply((Object)in).getOrElse((Function0 & Serializable & scala.Serializable)() -> reason)), MessageResponse$.MODULE$._json());
    }

    public JsonResult fromCode(int code, String message) {
        return new JsonResult(code, this.toEmpty(message, "Info"));
    }

    public JsonResult ok(JsValue json) {
        return new JsonResult(200, json);
    }

    public JsonResult ok(String message) {
        return this.ok(this.toEmpty(message, "Info"));
    }

    public JsonResult created(JsValue json) {
        return new JsonResult(201, json);
    }

    public JsonResult created(String message) {
        return this.created(this.toEmpty(message, "Info"));
    }

    public JsonResult accepted(JsValue json) {
        return new JsonResult(202, json);
    }

    public JsonResult accepted(String message) {
        return this.accepted(this.toEmpty(message, "Info"));
    }

    public JsonResult deprecated(JsValue json) {
        return new JsonResult(299, json);
    }

    public JsonResult deprecated(String message) {
        return this.deprecated(this.toEmpty(message, "Info"));
    }

    public JsonResult badRequest(JsValue json) {
        return new JsonResult(400, json);
    }

    public JsonResult badRequest(String message) {
        return this.badRequest(this.toEmpty(message, "Info"));
    }

    public JsonResult unauthorized(JsValue json) {
        return new JsonResult(401, json);
    }

    public JsonResult unauthorized(String message) {
        return this.unauthorized(this.toEmpty(message, "Info"));
    }

    public JsonResult forbidden(JsValue json) {
        return new JsonResult(403, json);
    }

    public JsonResult forbidden(String message) {
        return this.forbidden(this.toEmpty(message, "Info"));
    }

    public JsonResult notFound(JsValue json) {
        return new JsonResult(404, json);
    }

    public JsonResult notFound(String message) {
        return this.notFound(this.toEmpty(message, "ObjectNotFound"));
    }

    public JsonResult conflict(JsValue json) {
        return new JsonResult(409, json);
    }

    public JsonResult conflict(String message) {
        return this.conflict(this.toEmpty(message, "Info"));
    }

    public JsonResult error(Throwable ex) {
        return this.error(ex.getMessage());
    }

    public JsonResult error(JsValue ex) {
        return new JsonResult(500, ex);
    }

    public JsonResult error(String message) {
        return this.error(this.toEmpty(message, "Info"));
    }

    public JsonResult serviceUnavailable(JsValue json) {
        return new JsonResult(503, json);
    }

    public Result globalOnError(Throwable ex, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("globalOnError", ex);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.error(Json$.MODULE$.toJson((Object)new MessageResponse("Info", ex.getMessage()), MessageResponse$.MODULE$._json())).toResult();
    }

    public Result globalOnHandlerNotFound(ExecutionContext ec) {
        return this.notFound(Json$.MODULE$.toJson((Object)new MessageResponse("BadUrl", "URI Not Found"), MessageResponse$.MODULE$._json())).toResult();
    }

    public Result globalOnUnauthorized(ExecutionContext ec) {
        return this.unauthorized(Json$.MODULE$.toJson((Object)new MessageResponse("Info", "Unauthorized"), MessageResponse$.MODULE$._json())).toResult();
    }

    public Result globalOnBadRequest(String error, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(new StringBuilder(21).append("globalOnBadRequest - ").append(error).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.badRequest(Json$.MODULE$.toJson((Object)new MessageResponse("BadUrl", error), MessageResponse$.MODULE$._json())).toResult();
    }

    public Result applicationRoot(ExecutionContext ec, AppInfo appInfo) {
        ApplicationInfo info = new ApplicationInfo("App is running", appInfo.appName(), appInfo.version(), "Info".toString(), appInfo.startTime());
        JsValue obj = Json$.MODULE$.toJson((Object)info, ApplicationInfo$.MODULE$._json());
        return this.ok(obj).toResult();
    }

    public JsonResult apply(int code, JsValue message) {
        return new JsonResult(code, message);
    }

    public Option<Tuple2<Object, JsValue>> unapply(JsonResult x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$0.code()), (Object)x$0.message()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ JsonResult $anonfun$_format$1(int code, JsValue message) {
        return new JsonResult(code, message);
    }

    private JsonResult$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        OFormat underlying = (OFormat)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("code")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())), OFormat$.MODULE$.functionalCanBuildFormats(FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())), OWrites$.MODULE$.functionalCanBuildOWrites())).and((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("message")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.JsValueReads(), (Writes)Writes$.MODULE$.JsValueWrites()))).apply((Function2 & Serializable & scala.Serializable)(code, message) -> JsonResult$.$anonfun$_format$1(BoxesRunTime.unboxToInt((Object)code), message), package$.MODULE$.unlift((Function1 & Serializable & scala.Serializable)x$0 -> MODULE$.unapply((JsonResult)x$0)), OFormat$.MODULE$.invariantFunctorOFormat());
        Function1 & Serializable & scala.Serializable rfn = (Function1 & Serializable & scala.Serializable)x0$3 -> {
            JsError jsError;
            JsValue jsValue = x0$3;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                jsError = underlying.reads((JsValue)jsObject);
            } else {
                jsError = JsError$.MODULE$.apply("error.expected.jsobject");
            }
            return jsError;
        };
        this._format = OFormat$.MODULE$.apply((Function1)rfn, (Function1 & Serializable & scala.Serializable)o -> underlying.writes(o));
    }
}

