/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.bungeecord;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.facet.Facet;
import net.kyori.adventure.platform.facet.FacetBase;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.DefinedPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BungeeFacet<V extends CommandSender>
extends FacetBase<V> {
    static final BaseComponent[] EMPTY_COMPONENT_ARRAY = new BaseComponent[0];

    protected BungeeFacet(@Nullable Class<? extends V> viewerClass) {
        super(viewerClass);
    }

    static final class TabList
    extends Message
    implements Facet.TabList<ProxiedPlayer, BaseComponent[]> {
        TabList() {
        }

        public void send(ProxiedPlayer viewer, BaseComponent @Nullable [] header, BaseComponent @Nullable [] footer) {
            viewer.setTabHeader(header == null ? EMPTY_COMPONENT_ARRAY : header, footer == null ? EMPTY_COMPONENT_ARRAY : footer);
        }
    }

    static class BossBar
    extends Message
    implements Facet.BossBarPacket<ProxiedPlayer> {
        private final Set<ProxiedPlayer> viewers;
        private final net.md_5.bungee.protocol.packet.BossBar bar;
        private volatile boolean initialized = false;

        protected BossBar(@NotNull Collection<ProxiedPlayer> viewers) {
            this.viewers = new CopyOnWriteArraySet<ProxiedPlayer>(viewers);
            this.bar = new net.md_5.bungee.protocol.packet.BossBar(UUID.randomUUID(), 0);
        }

        public void bossBarInitialized(@NotNull net.kyori.adventure.bossbar.BossBar bar) {
            super.bossBarInitialized(bar);
            this.initialized = true;
            this.broadcastPacket(0);
        }

        public void bossBarNameChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, @NotNull Component oldName, @NotNull Component newName) {
            if (!this.viewers.isEmpty()) {
                this.bar.setTitle(ComponentSerializer.toString((BaseComponent[])this.createMessage(this.viewers.iterator().next(), newName)));
                this.broadcastPacket(3);
            }
        }

        public void bossBarProgressChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, float oldPercent, float newPercent) {
            this.bar.setHealth(newPercent);
            this.broadcastPacket(2);
        }

        public void bossBarColorChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Color newColor) {
            this.bar.setColor(this.createColor(newColor));
            this.broadcastPacket(4);
        }

        public void bossBarOverlayChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Overlay newOverlay) {
            this.bar.setDivision(this.createOverlay(newOverlay));
            this.broadcastPacket(4);
        }

        public void bossBarFlagsChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, @NotNull Set<BossBar.Flag> flagsAdded, @NotNull Set<BossBar.Flag> flagsRemoved) {
            this.bar.setFlags(this.createFlag(this.bar.getFlags(), flagsAdded, flagsRemoved));
            this.broadcastPacket(5);
        }

        public void addViewer(@NotNull ProxiedPlayer viewer) {
            this.viewers.add(viewer);
            this.sendPacket(0, viewer);
        }

        public void removeViewer(@NotNull ProxiedPlayer viewer) {
            this.viewers.remove(viewer);
            this.sendPacket(1, viewer);
        }

        public boolean isEmpty() {
            return !this.initialized || this.viewers.isEmpty();
        }

        public void close() {
            this.broadcastPacket(1);
            this.viewers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void broadcastPacket(int action) {
            if (this.isEmpty()) {
                return;
            }
            net.md_5.bungee.protocol.packet.BossBar bossBar = this.bar;
            synchronized (bossBar) {
                this.bar.setAction(action);
                for (ProxiedPlayer viewer : this.viewers) {
                    viewer.unsafe().sendPacket((DefinedPacket)this.bar);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPacket(int action, ProxiedPlayer ... viewers) {
            net.md_5.bungee.protocol.packet.BossBar bossBar = this.bar;
            synchronized (bossBar) {
                int lastAction = this.bar.getAction();
                this.bar.setAction(action);
                for (ProxiedPlayer viewer : viewers) {
                    viewer.unsafe().sendPacket((DefinedPacket)this.bar);
                }
                this.bar.setAction(lastAction);
            }
        }

        static class Builder
        extends BungeeFacet<ProxiedPlayer>
        implements Facet.BossBar.Builder<ProxiedPlayer, BossBar> {
            protected Builder() {
                super(ProxiedPlayer.class);
            }

            public boolean isApplicable(@NotNull ProxiedPlayer viewer) {
                return super.isApplicable((Object)viewer) && viewer.getPendingConnection().getVersion() >= 356;
            }

            public @NotNull BossBar createBossBar(@NotNull Collection<ProxiedPlayer> viewers) {
                return new BossBar(viewers);
            }
        }
    }

    static class Title
    extends Message
    implements Facet.Title<ProxiedPlayer, BaseComponent[], net.md_5.bungee.api.Title> {
        private static final net.md_5.bungee.api.Title CLEAR = ProxyServer.getInstance().createTitle().clear();
        private static final net.md_5.bungee.api.Title RESET = ProxyServer.getInstance().createTitle().reset();

        Title() {
        }

        public @NotNull net.md_5.bungee.api.Title createTitle(BaseComponent @Nullable [] title, BaseComponent @Nullable [] subTitle, int inTicks, int stayTicks, int outTicks) {
            net.md_5.bungee.api.Title builder = ProxyServer.getInstance().createTitle();
            if (title != null) {
                builder.title(title);
            }
            if (subTitle != null) {
                builder.subTitle(subTitle);
            }
            if (inTicks > -1) {
                builder.fadeIn(inTicks);
            }
            if (stayTicks > -1) {
                builder.stay(stayTicks);
            }
            if (outTicks > -1) {
                builder.fadeOut(outTicks);
            }
            return builder;
        }

        public void showTitle(@NotNull ProxiedPlayer viewer, @NotNull net.md_5.bungee.api.Title title) {
            viewer.sendTitle(title);
        }

        public void clearTitle(@NotNull ProxiedPlayer viewer) {
            viewer.sendTitle(CLEAR);
        }

        public void resetTitle(@NotNull ProxiedPlayer viewer) {
            viewer.sendTitle(RESET);
        }
    }

    static class ActionBar
    extends Message
    implements Facet.ActionBar<ProxiedPlayer, BaseComponent[]> {
        ActionBar() {
        }

        public void sendMessage(@NotNull ProxiedPlayer viewer, BaseComponent @NotNull [] message) {
            viewer.sendMessage(ChatMessageType.ACTION_BAR, message);
        }
    }

    static class ChatPlayer
    extends Message
    implements Facet.Chat<ProxiedPlayer, BaseComponent[]> {
        ChatPlayer() {
        }

        @Nullable
        public ChatMessageType createType(@NotNull MessageType type) {
            if (type == MessageType.CHAT) {
                return ChatMessageType.CHAT;
            }
            if (type == MessageType.SYSTEM) {
                return ChatMessageType.SYSTEM;
            }
            Knob.logUnsupported((Object)((Object)this), (Object)type);
            return null;
        }

        public void sendMessage(@NotNull ProxiedPlayer viewer, @NotNull Identity source, BaseComponent @NotNull [] message, @NotNull MessageType type) {
            ChatMessageType chat = this.createType(type);
            if (chat != null) {
                viewer.sendMessage(chat, message);
            }
        }
    }

    static class Message
    extends BungeeFacet<ProxiedPlayer>
    implements Facet.Message<ProxiedPlayer, BaseComponent[]> {
        protected Message() {
            super(ProxiedPlayer.class);
        }

        public BaseComponent @NotNull [] createMessage(@NotNull ProxiedPlayer viewer, @NotNull Component message) {
            if (viewer.getPendingConnection().getVersion() >= 713) {
                return BungeeComponentSerializer.get().serialize(message);
            }
            return BungeeComponentSerializer.legacy().serialize(message);
        }
    }

    static class ChatConsole
    extends BungeeFacet<CommandSender>
    implements Facet.Chat<CommandSender, BaseComponent[]> {
        protected ChatConsole() {
            super(CommandSender.class);
        }

        public boolean isApplicable(@NotNull CommandSender viewer) {
            return super.isApplicable((Object)viewer) && !(viewer instanceof Connection);
        }

        public BaseComponent @NotNull [] createMessage(@NotNull CommandSender viewer, @NotNull Component message) {
            return BungeeComponentSerializer.legacy().serialize(message);
        }

        public void sendMessage(@NotNull CommandSender viewer, @NotNull Identity source, BaseComponent @NotNull [] message, @NotNull MessageType type) {
            viewer.sendMessage(message);
        }
    }
}

