/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.lucko.commodore.Commodore;
import me.lucko.commodore.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;

final class CommodoreImpl
implements Commodore {
    private static final Field CONSOLE_FIELD;
    private static final Method GET_COMMAND_DISPATCHER_METHOD;
    private static final Method GET_BRIGADIER_DISPATCHER_METHOD;
    private final Plugin plugin;
    private final Object lock = new Object();
    private final List<LiteralCommandNode<?>> registeredNodes = new ArrayList();
    private List<LiteralCommandNode<?>> pendingRegistration = null;

    CommodoreImpl(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CommandDispatcher getDispatcher() {
        try {
            Object mcServerObject = CONSOLE_FIELD.get(Bukkit.getServer());
            Object commandDispatcherObject = GET_COMMAND_DISPATCHER_METHOD.invoke(mcServerObject, new Object[0]);
            return (CommandDispatcher)GET_BRIGADIER_DISPATCHER_METHOD.invoke(commandDispatcherObject, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<LiteralCommandNode<?>> getRegisteredNodes() {
        return Collections.unmodifiableList(this.registeredNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        CommandDispatcher dispatcher = this.getDispatcher();
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingRegistration == null) {
                return;
            }
            for (LiteralCommandNode<?> node : this.pendingRegistration) {
                dispatcher.getRoot().addChild(node);
                this.registeredNodes.add(node);
            }
            this.pendingRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(LiteralCommandNode<?> node) {
        Objects.requireNonNull(node, "node");
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingRegistration == null) {
                this.pendingRegistration = new ArrayList();
                this.plugin.getServer().getScheduler().runTaskLater(this.plugin, this::flush, 1L);
            }
            this.pendingRegistration.add(node);
        }
    }

    @Override
    public void register(Command command, LiteralCommandNode<?> node) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(node, "node");
        for (String alias : Lists.asList((Object)command.getLabel(), (Object[])command.getAliases().toArray(new String[0]))) {
            LiteralCommandNode toRegister = node;
            if (!node.getLiteral().equals(alias) && !node.getLiteral().equals(alias)) {
                LiteralCommandNode clone = new LiteralCommandNode(alias, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                for (CommandNode child : node.getChildren()) {
                    clone.addChild(child);
                }
                toRegister = clone;
            }
            this.register(toRegister);
        }
    }

    static {
        try {
            Class<?> craftServer = ReflectionUtil.obcClass("CraftServer");
            CONSOLE_FIELD = craftServer.getDeclaredField("console");
            CONSOLE_FIELD.setAccessible(true);
            Class<?> minecraftServer = ReflectionUtil.nmsClass("MinecraftServer");
            GET_COMMAND_DISPATCHER_METHOD = minecraftServer.getDeclaredMethod("getCommandDispatcher", new Class[0]);
            GET_COMMAND_DISPATCHER_METHOD.setAccessible(true);
            Class<?> commandDispatcher = ReflectionUtil.nmsClass("CommandDispatcher");
            Method getBrigadierDispatcherMethod = null;
            for (Method method : commandDispatcher.getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || !CommandDispatcher.class.isAssignableFrom(method.getReturnType())) continue;
                getBrigadierDispatcherMethod = method;
                break;
            }
            GET_BRIGADIER_DISPATCHER_METHOD = Objects.requireNonNull(getBrigadierDispatcherMethod, "getBrigadierDispatcherMethod");
            GET_BRIGADIER_DISPATCHER_METHOD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

