/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.lucko.commodore.Commodore;
import me.lucko.commodore.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;

final class CommodoreImpl
implements Commodore {
    private static final Field CONSOLE_FIELD;
    private static final Method GET_COMMAND_DISPATCHER_METHOD;
    private static final Method GET_BRIGADIER_DISPATCHER_METHOD;
    private static final Constructor<?> COMMAND_WRAPPER_CONSTRUCTOR;
    private static final Field CUSTOM_SUGGESTIONS_FIELD;
    private final List<LiteralCommandNode<?>> registeredNodes = new ArrayList();

    static void ensureSetup() {
    }

    CommodoreImpl(Plugin plugin) {
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onLoad(ServerLoadEvent e) {
                CommandDispatcher dispatcher = CommodoreImpl.this.getDispatcher();
                for (LiteralCommandNode node : CommodoreImpl.this.registeredNodes) {
                    dispatcher.getRoot().addChild((CommandNode)node);
                }
            }
        }, plugin);
    }

    @Override
    public CommandDispatcher getDispatcher() {
        try {
            Object mcServerObject = CONSOLE_FIELD.get(Bukkit.getServer());
            Object commandDispatcherObject = GET_COMMAND_DISPATCHER_METHOD.invoke(mcServerObject, new Object[0]);
            return (CommandDispatcher)GET_BRIGADIER_DISPATCHER_METHOD.invoke(commandDispatcherObject, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<LiteralCommandNode<?>> getRegisteredNodes() {
        return Collections.unmodifiableList(this.registeredNodes);
    }

    @Override
    public void register(LiteralCommandNode<?> node) {
        Objects.requireNonNull(node, "node");
        CommandDispatcher dispatcher = this.getDispatcher();
        dispatcher.getRoot().addChild(node);
        this.registeredNodes.add(node);
    }

    @Override
    public void register(Command command, LiteralCommandNode<?> node) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(node, "node");
        try {
            SuggestionProvider wrapper = (SuggestionProvider)COMMAND_WRAPPER_CONSTRUCTOR.newInstance(Bukkit.getServer(), command);
            this.applyServerSuggestionCall(wrapper, Collections.singleton(node));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (String alias : Lists.asList((Object)command.getLabel(), (Object[])command.getAliases().toArray(new String[0]))) {
            LiteralCommandNode toRegister = node;
            if (!node.getLiteral().equals(alias) && !node.getLiteral().equals(alias)) {
                LiteralCommandNode clone = new LiteralCommandNode(alias, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                for (CommandNode child : node.getChildren()) {
                    clone.addChild(child);
                }
                toRegister = clone;
            }
            this.register(toRegister);
        }
    }

    private void applyServerSuggestionCall(SuggestionProvider suggestionProvider, Collection<? extends CommandNode<?>> nodes) {
        for (CommandNode<?> node : nodes) {
            Collection children;
            if (node instanceof ArgumentCommandNode) {
                ArgumentCommandNode argumentNode = (ArgumentCommandNode)node;
                try {
                    CUSTOM_SUGGESTIONS_FIELD.set(argumentNode, suggestionProvider);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if ((children = node.getChildren()) == null || children.isEmpty()) continue;
            this.applyServerSuggestionCall(suggestionProvider, children);
        }
    }

    static {
        try {
            Class<?> craftServer = ReflectionUtil.obcClass("CraftServer");
            CONSOLE_FIELD = craftServer.getDeclaredField("console");
            CONSOLE_FIELD.setAccessible(true);
            Class<?> minecraftServer = ReflectionUtil.nmsClass("MinecraftServer");
            GET_COMMAND_DISPATCHER_METHOD = minecraftServer.getDeclaredMethod("getCommandDispatcher", new Class[0]);
            GET_COMMAND_DISPATCHER_METHOD.setAccessible(true);
            Class<?> commandDispatcher = ReflectionUtil.nmsClass("CommandDispatcher");
            Method getBrigadierDispatcherMethod = null;
            for (Method method : commandDispatcher.getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || !CommandDispatcher.class.isAssignableFrom(method.getReturnType())) continue;
                getBrigadierDispatcherMethod = method;
                break;
            }
            GET_BRIGADIER_DISPATCHER_METHOD = Objects.requireNonNull(getBrigadierDispatcherMethod, "getBrigadierDispatcherMethod");
            GET_BRIGADIER_DISPATCHER_METHOD.setAccessible(true);
            Class<?> commandWrapperClass = ReflectionUtil.obcClass("command.BukkitCommandWrapper");
            COMMAND_WRAPPER_CONSTRUCTOR = commandWrapperClass.getConstructor(craftServer, Command.class);
            CUSTOM_SUGGESTIONS_FIELD = ArgumentCommandNode.class.getDeclaredField("customSuggestions");
            CUSTOM_SUGGESTIONS_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

