/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore;

import org.bukkit.Bukkit;

final class ReflectionUtil {
    private static final String SERVER_VERSION = ReflectionUtil.getServerVersion();

    private static String getServerVersion() {
        Class<?> server = Bukkit.getServer().getClass();
        if (!server.getSimpleName().equals("CraftServer")) {
            return ".";
        }
        if (server.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            return ".";
        }
        String version = server.getName().substring("org.bukkit.craftbukkit".length());
        return version.substring(0, version.length() - "CraftServer".length());
    }

    public static String nms(String className) {
        return "net.minecraft.server" + SERVER_VERSION + className;
    }

    public static Class<?> nmsClass(String className) throws ClassNotFoundException {
        return Class.forName(ReflectionUtil.nms(className));
    }

    public static String obc(String className) {
        return "org.bukkit.craftbukkit" + SERVER_VERSION + className;
    }

    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(ReflectionUtil.obc(className));
    }

    private ReflectionUtil() {
    }
}

