/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore.file;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

class Lexer
extends AbstractIterator<Token>
implements PeekingIterator<Token> {
    private final StreamTokenizer tokenizer;
    private boolean end = false;

    Lexer(Reader reader) {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(33, 126);
        this.tokenizer.quoteChar(34);
        this.tokenizer.whitespaceChars(0, 32);
        "{};".chars().forEach(this.tokenizer::ordinaryChar);
        this.tokenizer.slashSlashComments(true);
        this.tokenizer.slashStarComments(true);
    }

    public int currentLine() {
        return this.tokenizer.lineno();
    }

    protected Token computeNext() {
        if (this.end) {
            return (Token)this.endOfData();
        }
        try {
            int token = this.tokenizer.nextToken();
            switch (token) {
                case -1: {
                    this.end = true;
                    return ConstantToken.EOF;
                }
                case -3: {
                    return new StringToken(this.tokenizer.sval);
                }
                case 123: {
                    return ConstantToken.OPEN_BRACKET;
                }
                case 125: {
                    return ConstantToken.CLOSE_BRACKET;
                }
                case 59: {
                    return ConstantToken.SEMICOLON;
                }
            }
            throw new LexerException(this, "Unknown token: " + (char)token + "(" + token + ")");
        }
        catch (IOException e) {
            throw new LexerException(this, e);
        }
    }

    static final class LexerException
    extends RuntimeException {
        private LexerException(Lexer lexer, String message) {
            super(message + " (at line " + lexer.currentLine() + ")");
        }

        private LexerException(Lexer lexer, Throwable cause) {
            super("At line " + lexer.currentLine(), cause);
        }
    }

    static final class StringToken
    implements Token {
        final String string;

        private StringToken(String string) {
            this.string = string;
        }
    }

    static enum ConstantToken implements Token
    {
        OPEN_BRACKET,
        CLOSE_BRACKET,
        SEMICOLON,
        EOF;

    }

    static interface Token {
    }
}

