/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore.file;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import me.lucko.commodore.MinecraftArgumentTypes;
import me.lucko.commodore.file.Lexer;
import org.bukkit.NamespacedKey;

class Parser<S> {
    private final Lexer lexer;

    Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    LiteralCommandNode<S> parse() {
        CommandNode<S> node = this.parseNode();
        if (!(node instanceof LiteralCommandNode)) {
            throw new ParserException(this, "Root command node is not a literal command node");
        }
        if (this.lexer.peek() != Lexer.ConstantToken.EOF) {
            throw new ParserException(this, "Expected end of file but got " + this.lexer.peek());
        }
        return (LiteralCommandNode)node;
    }

    private CommandNode<S> parseNode() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for node name but got " + token);
        }
        String name = ((Lexer.StringToken)token).string;
        Object node = this.lexer.peek() instanceof Lexer.StringToken ? RequiredArgumentBuilder.argument((String)name, this.parseArgumentType()) : LiteralArgumentBuilder.literal((String)name);
        if (this.lexer.peek() == Lexer.ConstantToken.OPEN_BRACKET) {
            this.lexer.next();
            while (this.lexer.peek() != Lexer.ConstantToken.CLOSE_BRACKET) {
                CommandNode<S> child = this.parseNode();
                node.then(child);
            }
            this.lexer.next();
        } else {
            if (this.lexer.peek() != Lexer.ConstantToken.SEMICOLON) {
                throw new ParserException(this, "Node definition not ended with semicolon, got " + this.lexer.peek());
            }
            this.lexer.next();
        }
        return node.build();
    }

    private ArgumentType<?> parseArgumentType() {
        String argumentType;
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for argument type but got " + token);
        }
        switch (argumentType = ((Lexer.StringToken)token).string) {
            case "brigadier:bool": {
                return BoolArgumentType.bool();
            }
            case "brigadier:string": {
                return this.parseStringArgumentType();
            }
            case "brigadier:integer": {
                return this.parseIntegerArgumentType();
            }
            case "brigadier:long": {
                return this.parseLongArgumentType();
            }
            case "brigadier:float": {
                return this.parseFloatArgumentType();
            }
            case "brigadier:double": {
                return this.parseDoubleArgumentType();
            }
            case "minecraft:entity": {
                return this.parseEntityArgumentType();
            }
            case "minecraft:score_holder": {
                return this.parseScoreHolderArgumentType();
            }
        }
        return this.parseMinecraftArgumentType(argumentType);
    }

    private ArgumentType<?> parseMinecraftArgumentType(String argumentType) {
        NamespacedKey namespacedKey;
        Object[] key = argumentType.split(":");
        if (key.length != 2) {
            throw new ParserException(this, "Invalid key for argument type: " + Arrays.toString(key));
        }
        try {
            namespacedKey = new NamespacedKey(key[0], key[1]);
        }
        catch (IllegalArgumentException e) {
            throw new ParserException(this, "Invalid key for argument type: " + argumentType, e);
        }
        try {
            return MinecraftArgumentTypes.getByKey(namespacedKey);
        }
        catch (Throwable e) {
            throw new ParserException(this, "Invalid key for argument type (not found in registry): " + argumentType, e);
        }
    }

    private ArgumentType<?> parseEntityArgumentType() {
        boolean playersOnly;
        boolean single;
        String entitySelectionType;
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for entity selection type but got " + token);
        }
        switch (entitySelectionType = ((Lexer.StringToken)token).string) {
            case "entity": {
                single = true;
                playersOnly = false;
                break;
            }
            case "entities": {
                single = false;
                playersOnly = false;
                break;
            }
            case "player": {
                single = true;
                playersOnly = true;
                break;
            }
            case "players": {
                single = false;
                playersOnly = true;
                break;
            }
            default: {
                throw new ParserException(this, "Unknown entity selection type: " + entitySelectionType);
            }
        }
        return Parser.constructMinecraftArgumentType(NamespacedKey.minecraft((String)"entity"), new Class[]{Boolean.TYPE, Boolean.TYPE}, single, playersOnly);
    }

    private ArgumentType<?> parseScoreHolderArgumentType() {
        boolean multiple = false;
        if (this.lexer.peek() instanceof Lexer.StringToken) {
            multiple = this.parseBoolean();
        }
        return Parser.constructMinecraftArgumentType(NamespacedKey.minecraft((String)"score_holder"), new Class[]{Boolean.TYPE}, multiple);
    }

    private static ArgumentType<?> constructMinecraftArgumentType(NamespacedKey key, Class<?>[] argTypes, Object ... args) {
        try {
            Constructor<ArgumentType<?>> constructor = MinecraftArgumentTypes.getClassByKey(key).getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private StringArgumentType parseStringArgumentType() {
        String stringType;
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for string type but got " + token);
        }
        switch (stringType = ((Lexer.StringToken)token).string) {
            case "single_word": {
                return StringArgumentType.word();
            }
            case "quotable_phrase": {
                return StringArgumentType.string();
            }
            case "greedy_phrase": {
                return StringArgumentType.greedyString();
            }
        }
        throw new ParserException(this, "Unknown string type: " + stringType);
    }

    private IntegerArgumentType parseIntegerArgumentType() {
        if (this.lexer.peek() instanceof Lexer.StringToken) {
            int min = this.parseInt();
            if (this.lexer.peek() instanceof Lexer.StringToken) {
                int max = this.parseInt();
                return IntegerArgumentType.integer((int)min, (int)max);
            }
            return IntegerArgumentType.integer((int)min);
        }
        return IntegerArgumentType.integer();
    }

    private LongArgumentType parseLongArgumentType() {
        if (this.lexer.peek() instanceof Lexer.StringToken) {
            long min = this.parseLong();
            if (this.lexer.peek() instanceof Lexer.StringToken) {
                long max = this.parseLong();
                return LongArgumentType.longArg((long)min, (long)max);
            }
            return LongArgumentType.longArg((long)min);
        }
        return LongArgumentType.longArg();
    }

    private FloatArgumentType parseFloatArgumentType() {
        if (this.lexer.peek() instanceof Lexer.StringToken) {
            float min = this.parseFloat();
            if (this.lexer.peek() instanceof Lexer.StringToken) {
                float max = this.parseFloat();
                return FloatArgumentType.floatArg((float)min, (float)max);
            }
            return FloatArgumentType.floatArg((float)min);
        }
        return FloatArgumentType.floatArg();
    }

    private DoubleArgumentType parseDoubleArgumentType() {
        if (this.lexer.peek() instanceof Lexer.StringToken) {
            double min = this.parseDouble();
            if (this.lexer.peek() instanceof Lexer.StringToken) {
                double max = this.parseDouble();
                return DoubleArgumentType.doubleArg((double)min, (double)max);
            }
            return DoubleArgumentType.doubleArg((double)min);
        }
        return DoubleArgumentType.doubleArg();
    }

    private int parseInt() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for integer but got " + token);
        }
        String value = ((Lexer.StringToken)token).string;
        if (value.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ParserException(this, "Expected int but got " + value, e);
        }
    }

    private long parseLong() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for long but got " + token);
        }
        String value = ((Lexer.StringToken)token).string;
        if (value.equals("min")) {
            return Long.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Long.MAX_VALUE;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ParserException(this, "Expected long but got " + value, e);
        }
    }

    private float parseFloat() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for float but got " + token);
        }
        String value = ((Lexer.StringToken)token).string;
        if (value.equals("min")) {
            return Float.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Float.MAX_VALUE;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ParserException(this, "Expected float but got " + value, e);
        }
    }

    private double parseDouble() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for double but got " + token);
        }
        String value = ((Lexer.StringToken)token).string;
        if (value.equals("min")) {
            return Double.MIN_VALUE;
        }
        if (value.equals("max")) {
            return Double.MAX_VALUE;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ParserException(this, "Expected double but got " + value);
        }
    }

    private boolean parseBoolean() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for boolean but got " + token);
        }
        String value = ((Lexer.StringToken)token).string;
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ParserException(this, "Expected true/false but got " + value);
    }

    static final class ParserException
    extends RuntimeException {
        private ParserException(Parser<?> parser, String message) {
            super(message + " (at line " + ((Parser)parser).lexer.currentLine() + ")");
        }

        private ParserException(Parser<?> parser, String message, Throwable cause) {
            super(message + " (at line " + ((Parser)parser).lexer.currentLine() + ")", cause);
        }
    }
}

