/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore;

import java.util.Objects;
import me.lucko.commodore.BrigadierUnsupportedException;
import me.lucko.commodore.Commodore;
import me.lucko.commodore.CommodoreImpl;
import org.bukkit.plugin.Plugin;

public final class CommodoreProvider {
    private static final Throwable SETUP_EXCEPTION = CommodoreProvider.checkSupported();

    private CommodoreProvider() {
        throw new AssertionError();
    }

    private static Throwable checkSupported() {
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
            CommodoreImpl.ensureSetup();
            return null;
        }
        catch (Throwable e) {
            if (System.getProperty("commodore.debug") != null) {
                System.err.println("Exception while initialising commodore:");
                e.printStackTrace(System.err);
            }
            return e;
        }
    }

    public static boolean isSupported() {
        return SETUP_EXCEPTION == null;
    }

    public static Commodore getCommodore(Plugin plugin) throws BrigadierUnsupportedException {
        Objects.requireNonNull(plugin, "plugin");
        if (SETUP_EXCEPTION != null) {
            throw new BrigadierUnsupportedException("Brigadier is not supported by the server.", SETUP_EXCEPTION);
        }
        return new CommodoreImpl(plugin);
    }
}

