/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.jarreloator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lucko.jarreloator.Relocation;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public final class JarRelocator {
    private final File input;
    private final File output;
    private final Collection<Relocation> relocations;

    public JarRelocator(File input, File output, Collection<Relocation> relocations) {
        this.input = input;
        this.output = output;
        this.relocations = relocations;
    }

    public void run() throws IOException {
        HashSet<String> resources = new HashSet<String>();
        RelocatingRemapper remapper = new RelocatingRemapper(this.relocations);
        try (JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.output)));){
            JarFile jarFile = new JarFile(this.input);
            Enumeration<JarEntry> j = jarFile.entries();
            while (j.hasMoreElements()) {
                JarEntry entry = j.nextElement();
                String name = entry.getName();
                if (name.equals("META-INF/INDEX.LIST") || entry.isDirectory()) continue;
                InputStream in = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String dir;
                    String mappedName = remapper.map(name);
                    int idx = mappedName.lastIndexOf(47);
                    if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                        this.addDirectory(resources, out, dir);
                    }
                    if (name.endsWith(".class")) {
                        this.addRemappedClass(remapper, out, name, in);
                        continue;
                    }
                    if (resources.contains(mappedName)) {
                        return;
                    }
                    this.addResource(resources, out, mappedName, entry.getTime(), in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            out.close();
        }
    }

    private void addDirectory(Set<String> resources, JarOutputStream jos, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addResource(Set<String> resources, JarOutputStream jos, String name, long lastModified, InputStream is) throws IOException {
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(lastModified);
        jos.putNextEntry(jarEntry);
        IOUtils.copy((InputStream)is, (OutputStream)jos);
        resources.add(name);
    }

    private void addRemappedClass(RelocatingRemapper remapper, JarOutputStream out, String name, InputStream in) throws IOException {
        ClassReader cr = new ClassReader(in);
        ClassWriter cw = new ClassWriter(0);
        final String pkg = name.substring(0, name.lastIndexOf(47) + 1);
        ClassRemapper cv = new ClassRemapper((ClassVisitor)cw, remapper){

            public void visitSource(String source, String debug) {
                if (source == null) {
                    super.visitSource(source, debug);
                } else {
                    String fqSource = pkg + source;
                    String mappedSource = this.remapper.map(fqSource);
                    String filename = mappedSource.substring(mappedSource.lastIndexOf(47) + 1);
                    super.visitSource(filename, debug);
                }
            }
        };
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable ise) {
            throw new RuntimeException("Error in ASM processing class " + name, ise);
        }
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        out.putNextEntry(new JarEntry(mappedName + ".class"));
        IOUtils.write((byte[])renamedClass, (OutputStream)out);
    }

    private static class RelocatingRemapper
    extends Remapper {
        private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+);");
        Collection<Relocation> relocations;

        private RelocatingRemapper(Collection<Relocation> relocations) {
            this.relocations = relocations;
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = this.classPattern.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocation r : this.relocations) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = this.classPattern.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocation r : this.relocations) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                break;
            }
            return value;
        }
    }
}

