/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.jarrelocator;

public final class Relocation {
    private final String pattern;
    private final String relocatedPattern;
    private final String pathPattern;
    private final String relocatedPathPattern;

    public Relocation(String pattern, String relocatedPattern) {
        this.pattern = pattern.replace('/', '.');
        this.pathPattern = pattern.replace('.', '/');
        this.relocatedPattern = relocatedPattern.replace('/', '.');
        this.relocatedPathPattern = relocatedPattern.replace('.', '/');
    }

    boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        return path.startsWith(this.pathPattern) || path.startsWith("/" + this.pathPattern);
    }

    boolean canRelocateClass(String clazz) {
        return clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.relocatedPathPattern);
    }

    String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.relocatedPattern);
    }

    String applyToSourceContent(String sourceContent) {
        return sourceContent.replaceAll("\\b" + this.pattern, this.relocatedPattern);
    }
}

