/*
 * Decompiled with CFR 0.152.
 */
package me.luckslovez.sling.models.extensions.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.luckslovez.sling.models.extensions.injectors.annotations.ResourceChildren;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component
public class ResourceChildrenInjector
implements Injector,
InjectAnnotationProcessorFactory2 {
    public String getName() {
        return "resource-children";
    }

    public Object getValue(@NotNull Object adaptable, @NotNull String fieldName, @NotNull Type type, @NotNull AnnotatedElement annotatedElement, @NotNull DisposalCallbackRegistry disposalCallbackRegistry) {
        ResourceChildren resourceChildrenAnnotation = annotatedElement.getAnnotation(ResourceChildren.class);
        if (resourceChildrenAnnotation != null) {
            Resource resource = adaptable instanceof SlingHttpServletRequest ? ((SlingHttpServletRequest)adaptable).getResource() : (Resource)adaptable;
            String name = resourceChildrenAnnotation.name();
            Optional<Class> adapter = Optional.of(annotatedElement).map(Field.class::cast).map(Field::getGenericType).flatMap(this::resolveClass).filter(clazz -> clazz != Resource.class);
            Stream<Object> result = StringUtils.isBlank((CharSequence)name) ? StreamSupport.stream(resource.getChildren().spliterator(), false) : (resource.getChild(name) != null ? StreamSupport.stream(resource.getChild(name).getChildren().spliterator(), false) : Stream.empty());
            return adapter.isPresent() ? result.map(child -> child.adaptTo((Class)adapter.get())).filter(Objects::nonNull).collect(Collectors.toList()) : result.collect(Collectors.toList());
        }
        return null;
    }

    private Optional<Class> resolveClass(Type type) {
        return Optional.of(type).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).map(ParameterizedType::getActualTypeArguments).map(Arrays::stream).orElseGet(Stream::empty).findAny().map(Class.class::cast);
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(@NotNull Object adaptable, @NotNull AnnotatedElement annotatedElement) {
        return Optional.of(annotatedElement).map(element -> element.getAnnotation(ResourceChildren.class)).map(ChildResourceChildrenProcessor::new).orElse(null);
    }

    private static class ChildResourceChildrenProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ResourceChildren annotation;

        ChildResourceChildrenProcessor(@NotNull ResourceChildren annotation) {
            this.annotation = annotation;
        }

        public String getName() {
            return this.annotation.name();
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }
    }
}

