/*
 * Decompiled with CFR 0.152.
 */
package me.luckslovez.sling.models.extensions.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.luckslovez.sling.models.extensions.injectors.annotations.ResourceChildrenValueMapValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component
public class ResourceChildrenValueMapValueInjector
implements Injector,
InjectAnnotationProcessorFactory2 {
    public String getName() {
        return "resource-children-valuemapvalue";
    }

    public Object getValue(@NotNull Object adaptable, @NotNull String fieldName, @NotNull Type type, @NotNull AnnotatedElement annotatedElement, @NotNull DisposalCallbackRegistry disposalCallbackRegistry) {
        ResourceChildrenValueMapValue resourceChildrenValueMapValue = annotatedElement.getAnnotation(ResourceChildrenValueMapValue.class);
        if (resourceChildrenValueMapValue != null) {
            Resource resource = adaptable instanceof SlingHttpServletRequest ? ((SlingHttpServletRequest)adaptable).getResource() : (Resource)adaptable;
            String name = resourceChildrenValueMapValue.name();
            String property = resourceChildrenValueMapValue.property();
            Optional<Class> adapter = Optional.of(annotatedElement).map(Field.class::cast).map(Field::getGenericType).flatMap(this::resolveClass).filter(clazz -> clazz != Resource.class);
            Stream result = StringUtils.isBlank((CharSequence)name) ? StreamSupport.stream(resource.getChildren().spliterator(), false) : (resource.getChild(name) != null ? StreamSupport.stream(resource.getChild(name).getChildren().spliterator(), false) : Stream.empty());
            return adapter.map(aClass -> result.map(child -> child.getValueMap().get(property, aClass)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(null);
        }
        return null;
    }

    private Optional<Class> resolveClass(Type type) {
        return Optional.of(type).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).map(ParameterizedType::getActualTypeArguments).map(Arrays::stream).orElseGet(Stream::empty).findAny().map(Class.class::cast);
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(@NotNull Object adaptable, @NotNull AnnotatedElement annotatedElement) {
        return Optional.of(annotatedElement).map(element -> element.getAnnotation(ResourceChildrenValueMapValue.class)).map(ResourceChildrenValueMapValueProcessor::new).orElse(null);
    }

    private static class ResourceChildrenValueMapValueProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ResourceChildrenValueMapValue annotation;

        ResourceChildrenValueMapValueProcessor(@NotNull ResourceChildrenValueMapValue annotation) {
            this.annotation = annotation;
        }

        public String getName() {
            return this.annotation.name();
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }
    }
}

