/*
 * Decompiled with CFR 0.152.
 */
package me.luckslovez.sling.models.extensions.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Optional;
import me.luckslovez.sling.models.extensions.injectors.annotations.SuffixParameter;
import me.luckslovez.sling.models.extensions.services.MapFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class SuffixParameterInjector
implements Injector,
InjectAnnotationProcessorFactory2 {
    @Reference
    private MapFactory mapFactory;

    @NotNull
    public String getName() {
        return "suffix-parameter";
    }

    public Object getValue(@NotNull Object adaptable, @NotNull String fieldName, @NotNull Type type, @NotNull AnnotatedElement annotatedElement, @NotNull DisposalCallbackRegistry disposalCallbackRegistry) {
        SuffixParameter suffixParameterAnnotation = annotatedElement.getAnnotation(SuffixParameter.class);
        if (suffixParameterAnnotation != null) {
            String name = Optional.of(suffixParameterAnnotation.name()).filter(StringUtils::isNotEmpty).orElseGet(() -> Optional.of(annotatedElement).map(Field.class::cast).map(Field::getName).orElse(null));
            String suffixSplitSeparator = suffixParameterAnnotation.suffixSplitSeparator();
            String keyValueSplitSeparator = suffixParameterAnnotation.keyValueSplitSeparator();
            return name != null ? Optional.of(adaptable).filter(SlingHttpServletRequest.class::isInstance).map(SlingHttpServletRequest.class::cast).map(SlingHttpServletRequest::getRequestPathInfo).map(RequestPathInfo::getSuffix).map(suffix -> StringUtils.substring((String)suffix, (int)1)).map(suffix -> StringUtils.split((String)suffix, (String)suffixSplitSeparator)).map(keyValues -> this.mapFactory.keyValuesToMap((String[])keyValues, keyValueSplitSeparator)).map(map -> map.get(name)).orElse(null) : "";
        }
        return null;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(@NotNull Object adaptable, @NotNull AnnotatedElement annotatedElement) {
        return Optional.of(annotatedElement).map(element -> element.getAnnotation(SuffixParameter.class)).map(RequestParameterAnnotationProcessor::new).orElse(null);
    }

    private static class RequestParameterAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final SuffixParameter annotation;

        RequestParameterAnnotationProcessor(@NotNull SuffixParameter annotation) {
            this.annotation = annotation;
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public String getName() {
            return this.annotation.name();
        }
    }
}

