/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.magnet.consultant.ConfigListener;
import me.magnet.consultant.KeyValueEntry;
import me.magnet.consultant.Path;
import me.magnet.consultant.PathParser;
import me.magnet.consultant.PropertiesUtil;
import me.magnet.consultant.ServiceIdentifier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConfigUpdater.class);
    private static final String PREFIX = "config";
    private final CloseableHttpClient httpClient;
    private final ScheduledExecutorService executor;
    private final String consulHost;
    private final ServiceIdentifier identifier;
    private final ObjectMapper objectMapper;
    private final Properties config;
    private final ConfigListener listener;
    private String consulIndex;

    ConfigUpdater(ScheduledExecutorService executor, CloseableHttpClient httpClient, String consulHost, String consulIndex, ServiceIdentifier identifier, ObjectMapper objectMapper, Properties config, ConfigListener listener) {
        this.httpClient = httpClient;
        this.consulIndex = consulIndex;
        this.objectMapper = objectMapper;
        this.executor = executor;
        this.consulHost = consulHost;
        this.identifier = identifier;
        this.listener = listener;
        this.config = config != null ? config : new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        long timeout = 500L;
        try {
            String url = this.consulHost + "/v1/kv/" + PREFIX + "/" + this.identifier.getServiceName() + "/?recurse=true";
            if (this.consulIndex != null) {
                url = url + "&index=" + this.consulIndex;
            }
            HttpGet request = new HttpGet(url);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
                Properties newConfig = new Properties();
                int status = response.getStatusLine().getStatusCode();
                switch (status) {
                    case 200: {
                        InputStream content = response.getEntity().getContent();
                        TypeReference<List<KeyValueEntry>> type = new TypeReference<List<KeyValueEntry>>(){};
                        List keys = (List)this.objectMapper.readValue(content, (TypeReference)type);
                        newConfig = this.updateConfig(keys);
                        this.onNewConfig(newConfig);
                        this.consulIndex = response.getFirstHeader("X-Consul-Index").getValue();
                        return;
                    }
                    case 404: {
                        timeout = 5000L;
                        this.onNewConfig(newConfig);
                        return;
                    }
                    case 204: 
                    case 504: {
                        return;
                    }
                    default: {
                        timeout = 60000L;
                        throw new RuntimeException("Failed to retrieve new config: " + response.getStatusLine().getReasonPhrase());
                    }
                }
            }
        }
        catch (IOException | RuntimeException e) {
            log.error("Error occurred while retrieving/publishing new config from Consul: " + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            ConfigUpdater task = new ConfigUpdater(this.executor, this.httpClient, this.consulHost, this.consulIndex, this.identifier, this.objectMapper, this.config, this.listener);
            this.executor.schedule(task, timeout, TimeUnit.MILLISECONDS);
        }
    }

    private void onNewConfig(Properties newConfig) {
        if (!this.config.equals(newConfig)) {
            PropertiesUtil.sync(newConfig, this.config);
            log.debug("New config detected in Consul: \n{}", (Object)newConfig.entrySet().stream().map(entry -> "\t" + entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining("\n")));
            if (this.listener != null) {
                this.listener.onConfigUpdate(this.config);
            }
        }
    }

    private Properties updateConfig(List<KeyValueEntry> entries) {
        HashMap newConfig = Maps.newHashMap();
        for (KeyValueEntry entry : entries) {
            Setting setting;
            String settingKey;
            ServiceIdentifier id;
            Path path = PathParser.parse(PREFIX, entry.getKey());
            if (path == null || !(id = path.getId()).appliesTo(this.identifier) || (settingKey = path.getKey()).isEmpty() || (setting = (Setting)newConfig.get(settingKey)) != null && !id.moreSpecificThan(setting.getIdentifier())) continue;
            String stringValue = new String(Base64.getDecoder().decode(entry.getValue()));
            newConfig.put(settingKey, new Setting(id, stringValue));
        }
        Properties properties = new Properties();
        newConfig.forEach((key, value) -> properties.setProperty((String)key, value.getValue()));
        return properties;
    }

    private static class Setting {
        private final ServiceIdentifier identifier;
        private final String value;

        public Setting(ServiceIdentifier identifier, String value) {
            this.identifier = identifier;
            this.value = value;
        }

        public ServiceIdentifier getIdentifier() {
            return this.identifier;
        }

        public String getValue() {
            return this.value;
        }
    }
}

