/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import me.magnet.consultant.ConfigListener;
import me.magnet.consultant.ConfigUpdater;
import me.magnet.consultant.ConfigValidator;
import me.magnet.consultant.ServiceIdentifier;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consultant {
    private static Logger log = LoggerFactory.getLogger(Consultant.class);
    private final CloseableHttpClient http;
    private final ScheduledExecutorService executor;
    private final String host;
    private final ServiceIdentifier id;
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigListener listener;
    private final ConfigValidator validator;
    private final Properties validated;

    public static Builder builder() {
        return new Builder();
    }

    private Consultant(ScheduledExecutorService executor, String host, ServiceIdentifier identifier, ConfigListener listener, ConfigValidator validator, CloseableHttpClient http) {
        this.listener = listener;
        this.validator = validator;
        this.executor = executor;
        this.host = host;
        this.id = identifier;
        this.validated = new Properties();
        this.http = http;
    }

    private void init() {
        log.info("Fetching initial configuration from Consul...");
        ConfigUpdater poller = new ConfigUpdater(this.executor, this.http, this.host, null, this.id, this.mapper, null, properties -> {
            if (this.validator == null) {
                this.updateValidatedConfig(properties);
            } else {
                try {
                    this.validator.validateConfig(properties);
                    this.updateValidatedConfig(properties);
                }
                catch (RuntimeException e) {
                    log.warn("New config did not pass validation: " + e.getMessage(), (Throwable)e);
                }
            }
        });
        try {
            this.executor.submit(poller).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void updateValidatedConfig(Properties newConfig) {
        Sets.SetView added = Sets.difference(newConfig.stringPropertyNames(), this.validated.stringPropertyNames());
        Sets.SetView removed = Sets.difference(this.validated.stringPropertyNames(), newConfig.stringPropertyNames());
        added.forEach(key -> this.validated.setProperty((String)key, newConfig.getProperty((String)key)));
        removed.forEach(this.validated::remove);
        if (this.listener != null) {
            this.listener.onConfigUpdate(this.validated);
        }
    }

    public void shutdown() {
        this.executor.shutdownNow();
        try {
            this.http.close();
        }
        catch (IOException e) {
            log.error("Error occurred on shutdown: " + e.getMessage(), (Throwable)e);
        }
    }

    public ServiceIdentifier getServiceIdentifier() {
        return this.id;
    }

    public Properties getProperties() {
        return this.validated;
    }

    public static class Builder {
        private ScheduledExecutorService executor;
        private String host;
        private ServiceIdentifier id;
        private ConfigListener listener;
        private ConfigValidator validator;
        private CloseableHttpClient http;

        private Builder() {
        }

        public Builder usingExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withConsulHost(String host) {
            this.host = host;
            return this;
        }

        public Builder identifyAs(String serviceName) {
            return this.identifyAs(serviceName, this.fromEnvironment("SERVICE_DC"), this.fromEnvironment("SERVICE_HOST"), Optional.ofNullable(this.fromEnvironment("SERVICE_INSTANCE")).orElse(UUID.randomUUID().toString()));
        }

        public Builder identifyAs(String serviceName, String datacenter) {
            return this.identifyAs(serviceName, datacenter, this.fromEnvironment("SERVICE_HOST"), Optional.ofNullable(this.fromEnvironment("SERVICE_INSTANCE")).orElse(UUID.randomUUID().toString()));
        }

        public Builder identifyAs(String serviceName, String datacenter, String hostname) {
            return this.identifyAs(serviceName, datacenter, hostname, Optional.ofNullable(this.fromEnvironment("SERVICE_INSTANCE")).orElse(UUID.randomUUID().toString()));
        }

        public Builder identifyAs(String serviceName, String datacenter, String hostname, String instanceName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceName) ? 1 : 0) != 0, (Object)"You must specify a 'serviceName'!");
            this.id = new ServiceIdentifier(serviceName, datacenter, hostname, instanceName);
            return this;
        }

        @VisibleForTesting
        Builder usingHttpClient(CloseableHttpClient httpClient) {
            this.http = httpClient;
            return this;
        }

        public Builder onValidConfig(ConfigListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder validateConfigWith(ConfigValidator validator) {
            this.validator = validator;
            return this;
        }

        public Consultant build() {
            if (Strings.isNullOrEmpty((String)this.host)) {
                this.host = this.fromEnvironment("CONSUL_HOST");
                if (Strings.isNullOrEmpty((String)this.host)) {
                    this.host = "http://localhost:8500";
                }
            }
            boolean executorSpecified = true;
            if (this.executor == null) {
                executorSpecified = false;
                this.executor = new ScheduledThreadPoolExecutor(1);
            }
            if (this.http == null) {
                PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
                manager.setMaxTotal(5);
                manager.setDefaultMaxPerRoute(5);
                this.http = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)manager).build();
            }
            if (this.id == null) {
                this.id = new ServiceIdentifier((String)Preconditions.checkNotNull((Object)this.fromEnvironment("SERVICE_NAME"), (Object)"You must specify the name of the service using SERVICE_NAME=<service_name>"), this.fromEnvironment("SERVICE_DC"), this.fromEnvironment("SERVICE_HOST"), Optional.ofNullable(this.fromEnvironment("SERVICE_INSTANCE")).orElse(UUID.randomUUID().toString()));
            }
            Consultant consultant = new Consultant(this.executor, this.host, this.id, this.listener, this.validator, this.http);
            consultant.init();
            if (!executorSpecified) {
                Runtime.getRuntime().addShutdownHook(new Thread(consultant::shutdown));
            }
            return consultant;
        }

        private String fromEnvironment(String key) {
            String property = System.getProperty(key);
            if (property != null) {
                return property;
            }
            property = System.getenv(key);
            if (property != null) {
                return property;
            }
            return null;
        }
    }
}

