/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ServiceIdentifier {
    private final String serviceName;
    private final Optional<String> datacenter;
    private final Optional<String> hostName;
    private final Optional<String> instance;

    ServiceIdentifier(String serviceName, String datacenter, String hostName, String instance) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceName) ? 1 : 0) != 0, (Object)"You must specify a 'serviceName'!");
        Preconditions.checkArgument((datacenter == null || !datacenter.isEmpty() ? 1 : 0) != 0, (Object)"You cannot specify 'datacenter' as empty String!");
        Preconditions.checkArgument((hostName == null || !hostName.isEmpty() ? 1 : 0) != 0, (Object)"You cannot specify 'hostName' as empty String!");
        Preconditions.checkArgument((instance == null || !instance.isEmpty() ? 1 : 0) != 0, (Object)"You cannot specify 'instance' as empty String!");
        this.datacenter = Optional.ofNullable(datacenter);
        this.hostName = Optional.ofNullable(hostName);
        this.serviceName = serviceName;
        this.instance = Optional.ofNullable(instance);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    public Optional<String> getHostName() {
        return this.hostName;
    }

    public Optional<String> getInstance() {
        return this.instance;
    }

    public boolean appliesTo(ServiceIdentifier mask) {
        Preconditions.checkNotNull((Object)mask, (Object)"You must specify a 'mask'!");
        if (!mask.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (mask.getDatacenter().isPresent() && this.getDatacenter().isPresent() && !mask.getDatacenter().equals(this.getDatacenter())) {
            return false;
        }
        if (mask.getHostName().isPresent() && this.getHostName().isPresent() && !mask.getHostName().equals(this.getHostName())) {
            return false;
        }
        return !mask.getInstance().isPresent() || !this.getInstance().isPresent() || mask.getInstance().equals(this.getInstance());
    }

    public boolean moreSpecificThan(ServiceIdentifier other) {
        Preconditions.checkNotNull((Object)other, (Object)"You must specify a 'other'!");
        if (!other.getInstance().isPresent() && this.getInstance().isPresent()) {
            return true;
        }
        if (!other.getHostName().isPresent() && this.getHostName().isPresent()) {
            return true;
        }
        return !other.getDatacenter().isPresent() && this.getDatacenter().isPresent();
    }

    public boolean equals(Object other) {
        if (other instanceof ServiceIdentifier) {
            ServiceIdentifier id = (ServiceIdentifier)other;
            return new EqualsBuilder().append((Object)this.serviceName, (Object)id.serviceName).append(this.datacenter, id.datacenter).append(this.hostName, id.hostName).append(this.instance, id.instance).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.serviceName).append(this.datacenter).append(this.hostName).append(this.instance).toHashCode();
    }

    public String toString() {
        ArrayList descriptors = Lists.newArrayList();
        this.getDatacenter().ifPresent(dc -> descriptors.add("dc=" + dc));
        this.getHostName().ifPresent(host -> descriptors.add("host=" + host));
        this.getInstance().ifPresent(instance -> descriptors.add("instance=" + instance));
        StringBuilder builder = new StringBuilder(this.serviceName);
        if (!descriptors.isEmpty()) {
            builder.append("[");
            builder.append(descriptors.stream().collect(Collectors.joining(",")));
            builder.append("]");
        }
        return builder.toString();
    }
}

