/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.base.Strings;
import com.netflix.governator.configuration.AbstractObjectConfigurationProvider;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.Property;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import me.magnet.consultant.Consultant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultantConfigurationProvider
extends AbstractObjectConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(ConsultantConfigurationProvider.class);
    private final Consultant consultant;
    private final DateFormat dateFormat;

    public ConsultantConfigurationProvider(Consultant consultant) {
        this(consultant, DateFormat.getInstance());
    }

    public ConsultantConfigurationProvider(Consultant consultant, DateFormat dateFormat) {
        this.consultant = consultant;
        this.dateFormat = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Property<Boolean> getBooleanProperty(final ConfigurationKey configurationKey, final Boolean defaultValue) {
        return new Property<Boolean>(){

            public Boolean get() {
                String rawKey = configurationKey.getRawKey();
                String value = ConsultantConfigurationProvider.this.consultant.getProperties().getProperty(rawKey);
                if (Strings.isNullOrEmpty((String)value)) {
                    return defaultValue;
                }
                return Boolean.parseBoolean(value);
            }
        };
    }

    public Property<Integer> getIntegerProperty(final ConfigurationKey configurationKey, final Integer defaultValue) {
        return new Property<Integer>(){

            public Integer get() {
                String rawKey = configurationKey.getRawKey();
                try {
                    String value = ConsultantConfigurationProvider.this.consultant.getProperties().getProperty(rawKey);
                    if (Strings.isNullOrEmpty((String)value)) {
                        return defaultValue;
                    }
                    return Integer.parseInt(value);
                }
                catch (RuntimeException e) {
                    log.error("Failed to parse integer: " + rawKey + ": {}", (Object)e.getMessage(), (Object)e);
                    return defaultValue;
                }
            }
        };
    }

    public Property<Long> getLongProperty(final ConfigurationKey configurationKey, final Long defaultValue) {
        return new Property<Long>(){

            public Long get() {
                String rawKey = configurationKey.getRawKey();
                try {
                    String value = ConsultantConfigurationProvider.this.consultant.getProperties().getProperty(rawKey);
                    if (Strings.isNullOrEmpty((String)value)) {
                        return defaultValue;
                    }
                    return Long.parseLong(value);
                }
                catch (RuntimeException e) {
                    log.error("Failed to parse long: " + rawKey + ": {}", (Object)e.getMessage(), (Object)e);
                    return defaultValue;
                }
            }
        };
    }

    public Property<Double> getDoubleProperty(final ConfigurationKey configurationKey, final Double defaultValue) {
        return new Property<Double>(){

            public Double get() {
                String rawKey = configurationKey.getRawKey();
                try {
                    String value = ConsultantConfigurationProvider.this.consultant.getProperties().getProperty(rawKey);
                    if (Strings.isNullOrEmpty((String)value)) {
                        return defaultValue;
                    }
                    return Double.parseDouble(value);
                }
                catch (RuntimeException e) {
                    log.error("Failed to parse double: " + rawKey + ": {}", (Object)e.getMessage(), (Object)e);
                    return defaultValue;
                }
            }
        };
    }

    public Property<String> getStringProperty(final ConfigurationKey configurationKey, final String defaultValue) {
        return new Property<String>(){

            public String get() {
                String rawKey = configurationKey.getRawKey();
                String value = ConsultantConfigurationProvider.this.consultant.getProperties().getProperty(rawKey);
                if (value == null) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    public Property<Date> getDateProperty(final ConfigurationKey configurationKey, final Date defaultValue) {
        return new Property<Date>(){

            public Date get() {
                String rawKey = configurationKey.getRawKey();
                try {
                    String value = ConsultantConfigurationProvider.this.consultant.getProperties().getProperty(rawKey);
                    if (Strings.isNullOrEmpty((String)value)) {
                        return defaultValue;
                    }
                    return ConsultantConfigurationProvider.this.dateFormat.parse(value);
                }
                catch (RuntimeException | ParseException e) {
                    log.error("Failed to parse date: " + rawKey + ": {}", (Object)e.getMessage(), (Object)e);
                    return defaultValue;
                }
            }
        };
    }

    public boolean has(ConfigurationKey key) {
        return this.consultant.getProperties().containsKey(key.getRawKey());
    }
}

