/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.magnet.consultant.Path;
import me.magnet.consultant.ServiceIdentifier;

class PathParser {
    private static final Pattern DC_FIELD = Pattern.compile("^dc\\s*=\\s*(?<dc>.*)$");
    private static final Pattern HOST_FIELD = Pattern.compile("^host\\s*=\\s*(?<host>.*)$");
    private static final Pattern INSTANCE_FIELD = Pattern.compile("^instance\\s*=\\s*(?<instance>.*)$");

    static Path parse(String prefix, String path) {
        String serviceName;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"You must specify an 'path'!");
        String tail = path;
        if (prefix != null) {
            if (!path.startsWith(prefix + "/")) {
                return null;
            }
            tail = path.substring(prefix.length() + 1);
        }
        String datacenter = null;
        String hostName = null;
        String serviceInstance = null;
        if (tail.contains("/[")) {
            String[] splits;
            int index = tail.indexOf("/[");
            serviceName = tail.substring(0, index);
            String part = tail.substring(index + 2);
            part = part.substring(0, part.indexOf(93));
            for (String split : splits = part.split(",")) {
                Matcher matcher;
                if (datacenter == null && (matcher = DC_FIELD.matcher(split)).find()) {
                    datacenter = matcher.group("dc");
                    continue;
                }
                if (hostName == null && (matcher = HOST_FIELD.matcher(split)).find()) {
                    hostName = matcher.group("host");
                    continue;
                }
                if (serviceInstance != null || !(matcher = INSTANCE_FIELD.matcher(split)).find()) continue;
                serviceInstance = matcher.group("instance");
            }
            if ((tail = tail.substring(tail.indexOf("]") + 1)).startsWith(".")) {
                tail = tail.substring(1);
            }
        } else if (tail.contains("/")) {
            serviceName = tail.substring(0, tail.indexOf("/"));
            tail = tail.substring(tail.indexOf("/") + 1);
        } else {
            serviceName = tail;
            tail = "";
        }
        ServiceIdentifier id = new ServiceIdentifier(serviceName, datacenter, hostName, serviceInstance);
        return new Path(prefix, id, Strings.emptyToNull((String)tail));
    }

    private PathParser() {
    }
}

