/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class PropertiesUtil {
    public static Map<String, Pair<String, String>> sync(Properties source, Properties target) {
        Preconditions.checkNotNull((Object)source, (Object)"You must specify a 'source' Properties object!");
        Preconditions.checkNotNull((Object)target, (Object)"You must specify a 'source' Properties object!");
        Set<String> sourceKeys = source.stringPropertyNames();
        Set<String> targetKeys = target.stringPropertyNames();
        HashSet added = Sets.newHashSet((Iterable)Sets.difference(sourceKeys, targetKeys));
        HashSet modified = Sets.newHashSet((Iterable)Sets.intersection(sourceKeys, targetKeys));
        HashSet removed = Sets.newHashSet((Iterable)Sets.difference(targetKeys, sourceKeys));
        HashMap changes = Maps.newHashMap();
        added.forEach(key -> {
            String newValue = source.getProperty((String)key);
            changes.put(key, Pair.of(null, (Object)newValue));
            target.setProperty((String)key, newValue);
        });
        modified.forEach(key -> {
            String oldValue = target.getProperty((String)key);
            String newValue = source.getProperty((String)key);
            changes.put(key, Pair.of((Object)oldValue, (Object)newValue));
            target.setProperty((String)key, newValue);
        });
        removed.forEach(key -> {
            String oldValue = target.getProperty((String)key);
            changes.put(key, Pair.of((Object)oldValue, null));
            target.remove(key);
        });
        return changes;
    }

    private PropertiesUtil() {
    }
}

