/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.stream.Collectors;
import me.magnet.consultant.ServiceIdentifier;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class Path {
    private final String prefix;
    private final ServiceIdentifier id;
    private final String key;

    Path(String prefix, ServiceIdentifier id, String key) {
        Preconditions.checkNotNull((Object)id, (Object)"You must specify an 'id'!");
        this.prefix = prefix;
        this.id = id;
        this.key = key;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ServiceIdentifier getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.prefix).append((Object)this.id).append((Object)this.key).toHashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Path) {
            Path path = (Path)other;
            return new EqualsBuilder().append((Object)this.prefix, (Object)path.prefix).append((Object)this.id, (Object)path.id).append((Object)this.key, (Object)path.key).isEquals();
        }
        return false;
    }

    public String toString() {
        ArrayList descriptors = Lists.newArrayList();
        this.id.getDatacenter().ifPresent(dc -> descriptors.add("dc=" + dc));
        this.id.getHostName().ifPresent(host -> descriptors.add("host=" + host));
        this.id.getInstance().ifPresent(instance -> descriptors.add("instance=" + instance));
        StringBuilder builder = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.prefix)) {
            builder.append(this.prefix).append("/");
        }
        builder.append(this.id.getServiceName());
        if (!descriptors.isEmpty()) {
            builder.append("/[").append(descriptors.stream().collect(Collectors.joining(","))).append("]");
        }
        if (!Strings.isNullOrEmpty((String)this.key)) {
            builder.append("/").append(this.key);
        }
        return builder.toString();
    }
}

