/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import me.magnet.consultant.ConsulException;
import me.magnet.consultant.ConsultantException;
import me.magnet.consultant.ServiceInstance;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ServiceInstanceBackend {
    private final URI consulUri;
    private final ObjectMapper objectMapper;
    private final CloseableHttpClient http;
    private final Optional<String> datacenter;

    ServiceInstanceBackend(Optional<String> datacenter, URI consulUri, ObjectMapper objectMapper, CloseableHttpClient http) {
        this.datacenter = datacenter;
        this.consulUri = consulUri;
        this.objectMapper = objectMapper;
        this.http = http;
    }

    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    public List<ServiceInstance> listInstances(String serviceName) {
        return this.listInstances(serviceName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ServiceInstance> listInstances(String serviceName, String datacenter) {
        String url = this.consulUri + "/v1/health/service/" + serviceName + "?passing&near=_agent";
        if (!Strings.isNullOrEmpty((String)datacenter)) {
            url = url + "&dc=" + datacenter;
        }
        HttpGet request = new HttpGet(url);
        request.setHeader("User-Agent", "Consultant");
        try (CloseableHttpResponse response = this.http.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 400) {
                InputStream content = response.getEntity().getContent();
                List list = (List)this.objectMapper.readValue(content, (TypeReference)new TypeReference<List<ServiceInstance>>(){});
                return list;
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new ConsultantException("Could not locate service: " + serviceName, new ConsulException(statusCode, body));
        }
        catch (IOException | RuntimeException e) {
            throw new ConsultantException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatacenters() {
        String url = this.consulUri + "/v1/catalog/datacenters";
        HttpGet request = new HttpGet(url);
        request.setHeader("User-Agent", "Consultant");
        try (CloseableHttpResponse response = this.http.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 400) {
                InputStream content = response.getEntity().getContent();
                List list = (List)this.objectMapper.readValue(content, (TypeReference)new TypeReference<List<String>>(){});
                return list;
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new ConsultantException("Could not locate datacenters", new ConsulException(statusCode, body));
        }
        catch (IOException | RuntimeException e) {
            throw new ConsultantException(e);
        }
    }
}

