/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.magnet.consultant.ServiceInstance;

public class ServiceLocator {
    private final Supplier<Iterator<ServiceInstance>> instanceSupplier;
    private final Supplier<ServiceLocator> fallbackSupplier;
    private Iterator<ServiceInstance> instances;
    private ServiceLocator fallback;
    private Consumer<ServiceInstance> listener;

    ServiceLocator(Supplier<Iterator<ServiceInstance>> instanceSupplier) {
        this(instanceSupplier, (ServiceLocator)null);
    }

    ServiceLocator(Supplier<Iterator<ServiceInstance>> instanceSupplier, ServiceLocator fallback) {
        this(instanceSupplier, () -> fallback);
    }

    ServiceLocator(Supplier<Iterator<ServiceInstance>> instanceSupplier, Supplier<ServiceLocator> fallbackSupplier) {
        this.instanceSupplier = instanceSupplier;
        this.fallbackSupplier = fallbackSupplier;
    }

    ServiceLocator setListener(Consumer<ServiceInstance> listener) {
        this.listener = listener;
        if (this.fallback != null) {
            this.fallback.setListener(listener);
        }
        return this;
    }

    ServiceLocator map(Function<Iterator<ServiceInstance>, Iterator<ServiceInstance>> mapper) {
        if (this.fallback != null) {
            return new ServiceLocator(() -> (Iterator)mapper.apply(this.instanceSupplier.get()), this.fallback.map(mapper));
        }
        return new ServiceLocator(() -> (Iterator)mapper.apply(this.instanceSupplier.get()));
    }

    public Optional<ServiceInstance> next() {
        if (this.instances == null) {
            this.instances = this.instanceSupplier.get();
        }
        if (this.instances.hasNext()) {
            ServiceInstance instance = this.instances.next();
            if (this.listener != null) {
                this.listener.accept(instance);
            }
            return Optional.of(instance);
        }
        if (this.fallback == null) {
            this.fallback = this.fallbackSupplier.get();
        }
        if (this.fallback != null) {
            return this.fallback.next();
        }
        return Optional.empty();
    }
}

