/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.magnet.consultant.Check;
import me.magnet.consultant.ConfigListener;
import me.magnet.consultant.ConfigUpdater;
import me.magnet.consultant.ConfigValidator;
import me.magnet.consultant.ConsulException;
import me.magnet.consultant.ConsultantException;
import me.magnet.consultant.Node;
import me.magnet.consultant.PropertiesUtil;
import me.magnet.consultant.RoutingStrategies;
import me.magnet.consultant.RoutingStrategy;
import me.magnet.consultant.Service;
import me.magnet.consultant.ServiceIdentifier;
import me.magnet.consultant.ServiceInstance;
import me.magnet.consultant.ServiceInstanceBackend;
import me.magnet.consultant.ServiceLocator;
import me.magnet.consultant.ServiceRegistration;
import me.magnet.consultant.SettingListener;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consultant {
    private static final int HEALTH_CHECK_INTERVAL = 10;
    private static final int TERMINATION_TIMEOUT_SECONDS = 5;
    private ConfigUpdater poller;
    private static Logger log = LoggerFactory.getLogger(Consultant.class);
    private final AtomicBoolean registered;
    private final CloseableHttpClient http;
    private final ScheduledExecutorService executor;
    private final URI consulUri;
    private final ServiceIdentifier id;
    private final ObjectMapper mapper;
    private final ConfigValidator validator;
    private final Properties validated;
    private final boolean pullConfig;
    private final String healthEndpoint;
    private final String kvPrefix;
    private final ServiceInstanceBackend serviceInstanceBackend;
    private final Multimap<String, SettingListener> settingListeners;
    private final Set<ConfigListener> configListeners;
    private final AtomicBoolean shutdownBegun = new AtomicBoolean(false);

    public static Builder builder() {
        return new Builder();
    }

    private Consultant(ScheduledExecutorService executor, ObjectMapper mapper, URI consulUri, ServiceIdentifier identifier, SetMultimap<String, SettingListener> settingListeners, Set<ConfigListener> configListeners, ConfigValidator validator, CloseableHttpClient http, boolean pullConfig, String healthEndpoint, String kvPrefix, long whenLocatingServicesCacheResultsFor) {
        this.registered = new AtomicBoolean();
        this.settingListeners = Multimaps.synchronizedSetMultimap(settingListeners);
        this.configListeners = Sets.newConcurrentHashSet(configListeners);
        this.serviceInstanceBackend = new ServiceInstanceBackend(identifier.getDatacenter(), consulUri, mapper, http, whenLocatingServicesCacheResultsFor);
        this.mapper = mapper;
        this.validator = validator;
        this.executor = executor;
        this.consulUri = consulUri;
        this.id = identifier;
        this.pullConfig = pullConfig;
        this.validated = new Properties();
        this.healthEndpoint = healthEndpoint;
        this.http = http;
        this.kvPrefix = kvPrefix;
    }

    private void init(Properties initProperties) {
        this.updateValidatedConfig(initProperties);
        if (!this.pullConfig) {
            return;
        }
        log.info("Fetching initial configuration from Consul for serviceID: {}", (Object)this.id);
        this.poller = new ConfigUpdater(this.executor, this.http, this.consulUri, null, this.id, this.mapper, null, properties -> {
            if (this.validator == null) {
                this.updateValidatedConfig(properties);
            } else {
                try {
                    this.validator.validateConfig(properties);
                    this.updateValidatedConfig(properties);
                }
                catch (RuntimeException e) {
                    log.warn("New config did not pass validation: " + e.getMessage(), (Throwable)e);
                }
            }
        }, this.kvPrefix);
        try {
            this.executor.submit(this.poller).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new ConsultantException(e.getCause());
        }
    }

    public void registerService(int port) {
        if (!this.registered.compareAndSet(false, true)) {
            log.warn("Cannot register the service, as service was already registered!");
            return;
        }
        String url = this.consulUri + "/v1/agent/service/register";
        log.info("Registering service with Consul: {}", (Object)this.id);
        try {
            String serviceId = this.id.getInstance().get();
            String serviceName = this.id.getServiceName();
            String serviceHost = this.id.getHostName().get();
            Check check = new Check("http://" + serviceHost + ":" + port + this.healthEndpoint, 10);
            ServiceRegistration registration = new ServiceRegistration(serviceId, serviceName, serviceHost, port, check, new String[0]);
            String serialized = this.mapper.writeValueAsString((Object)registration);
            HttpPut request = new HttpPut(url);
            request.setEntity((HttpEntity)new StringEntity(serialized));
            request.setHeader("User-Agent", "Consultant");
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.http.execute((HttpUriRequest)request);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 400) {
                    return;
                }
                try {
                    log.error("Could not register service, status: " + statusCode);
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new ConsultantException("Could not register service", new ConsulException(statusCode, body));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException | RuntimeException e) {
            this.registered.set(false);
            log.error("Could not register service!", (Throwable)e);
            throw new ConsultantException(e);
        }
    }

    public void deregisterService() {
        if (!this.registered.compareAndSet(true, false)) {
            log.warn("Cannot deregister the service, as service wasn't registered or was already deregistered!");
            return;
        }
        String serviceId = this.id.getInstance().get();
        String url = this.consulUri + "/v1/agent/service/deregister/" + serviceId;
        log.info("Deregistering service from Consul: {}", (Object)this.id);
        HttpPut request = new HttpPut(url);
        request.setHeader("User-Agent", "Consultant");
        try {
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.http.execute((HttpUriRequest)request);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 400) {
                    return;
                }
                try {
                    log.error("Could not deregister service, status: " + statusCode);
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new ConsultantException("Could not deregister service", new ConsulException(statusCode, body));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException | RuntimeException e) {
            this.registered.set(true);
            log.error("Could not deregister service!", (Throwable)e);
            throw new ConsultantException(e);
        }
    }

    @Deprecated
    public List<ServiceInstance> list(String serviceName) {
        Optional<ServiceInstance> instance;
        ArrayList instances = Lists.newArrayList();
        ServiceLocator locator = this.locateAll(serviceName, RoutingStrategies.NETWORK_DISTANCE);
        while ((instance = locator.next()).isPresent()) {
            instances.add(instance.get());
        }
        return instances;
    }

    public ServiceLocator locateAll(String serviceName) {
        return this.locateAll(serviceName, RoutingStrategies.RANDOMIZED_WEIGHTED_DISTANCE);
    }

    public ServiceLocator locateAll(String serviceName, RoutingStrategy routingStrategy) {
        return routingStrategy.locateInstances(this.serviceInstanceBackend, serviceName);
    }

    @Deprecated
    public Optional<InetSocketAddress> locate(String serviceName) {
        return this.locateAll(serviceName, RoutingStrategies.NETWORK_DISTANCE).next().map(instance -> {
            Node node = instance.getNode();
            Service service = instance.getService();
            String address = Optional.ofNullable(node.getAddress()).orElse(service.getAddress());
            return new InetSocketAddress(address, (int)service.getPort());
        });
    }

    public void addConfigListener(ConfigListener listener) {
        this.configListeners.add(listener);
    }

    public boolean removeConfigListener(ConfigListener listener) {
        return this.configListeners.remove(listener);
    }

    public void addSettingListener(String key, SettingListener listener) {
        this.settingListeners.put((Object)key, (Object)listener);
    }

    public boolean removeSettingListener(String key, SettingListener listener) {
        return this.settingListeners.remove((Object)key, (Object)listener);
    }

    private void updateValidatedConfig(Properties newConfig) {
        Map<String, Pair<String, String>> changes = PropertiesUtil.sync(newConfig, this.validated);
        if (changes.isEmpty()) {
            return;
        }
        for (ConfigListener configListener : this.configListeners) {
            configListener.onConfigUpdate(this.validated);
        }
        for (Map.Entry entry : changes.entrySet()) {
            String key = (String)entry.getKey();
            Collection listeners = this.settingListeners.get((Object)key);
            if (listeners == null || listeners.isEmpty()) continue;
            for (SettingListener listener : listeners) {
                Pair change = (Pair)entry.getValue();
                if (Objects.equals(change.getLeft(), change.getRight())) continue;
                listener.onSettingUpdate(key, (String)change.getLeft(), (String)change.getRight());
            }
        }
    }

    public void shutdown() throws InterruptedException {
        boolean allTasksTerminated;
        if (this.registered.get()) {
            try {
                this.deregisterService();
            }
            catch (ConsultantException e) {
                log.error("Error occurred while deregistering", (Throwable)e);
            }
        }
        this.executor.shutdownNow();
        this.shutdownBegun.set(true);
        if (this.poller != null) {
            this.poller.shutdown();
        }
        try {
            this.http.close();
        }
        catch (IOException | RuntimeException e) {
            log.error("Error occurred on shutdown: " + e.getMessage(), (Throwable)e);
        }
        if (this.pullConfig && !this.executor.isShutdown() && !(allTasksTerminated = this.executor.awaitTermination(5L, TimeUnit.SECONDS))) {
            log.warn("Could not shut down all executor tasks!");
        }
    }

    public String getConsulHost() {
        return this.consulUri.toString();
    }

    public ServiceIdentifier getServiceIdentifier() {
        return this.id;
    }

    public Properties getProperties() {
        return this.validated;
    }

    public static class Builder {
        private static final int CONSUL_DEFAULT_PORT = 8500;
        private static final String CONSUL_ADDRESS = "http://localhost:8500";
        private ScheduledExecutorService executor;
        private ObjectMapper mapper;
        private CloseableHttpClient http;
        private ConfigValidator validator;
        private final SetMultimap<String, SettingListener> settingListeners = HashMultimap.create();
        private final Set<ConfigListener> configListeners = Sets.newHashSet();
        private String host;
        private Properties properties = new Properties();
        private boolean pullConfig = true;
        private String serviceName;
        private String kvPrefix;
        private String datacenter;
        private String hostname;
        private String instanceName;
        private String healthEndpoint = "/_health";
        private long whenLocatingServicesCacheResultsFor = 1000L;
        private URI consulURI;

        private Builder() {
        }

        public Builder usingExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder usingObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder withConsulHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withKvPrefix(String kvPrefix) {
            this.kvPrefix = kvPrefix;
            return this;
        }

        public Builder identifyAs(String serviceName) {
            return this.identifyAs(serviceName, null, null, null);
        }

        public Builder identifyAs(String serviceName, String datacenter) {
            return this.identifyAs(serviceName, datacenter, null, null);
        }

        public Builder identifyAs(String serviceName, String datacenter, String hostname) {
            return this.identifyAs(serviceName, datacenter, hostname, null);
        }

        public Builder identifyAs(String serviceName, String datacenter, String hostname, String instanceName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceName) ? 1 : 0) != 0, (Object)"You must specify a 'serviceName'!");
            this.serviceName = serviceName;
            this.datacenter = datacenter;
            this.hostname = hostname;
            this.instanceName = instanceName;
            return this;
        }

        public Builder setHealthEndpoint(String endpoint) {
            this.healthEndpoint = endpoint;
            return this;
        }

        @VisibleForTesting
        Builder usingHttpClient(CloseableHttpClient httpClient) {
            this.http = httpClient;
            return this;
        }

        public Builder onValidConfig(ConfigListener listener) {
            this.configListeners.add(listener);
            return this;
        }

        public Builder onSettingUpdate(String key, SettingListener listener) {
            this.settingListeners.put((Object)key, (Object)listener);
            return this;
        }

        public Builder validateConfigWith(ConfigValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder pullConfigFromConsul(boolean pullConfig) {
            this.pullConfig = pullConfig;
            return this;
        }

        public Builder startWith(Properties properties) {
            Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"You must specify a non-null Properties object!");
            this.properties = properties;
            return this;
        }

        public Builder whenLocatingServicesCacheResultsFor(long duration, TimeUnit unit) {
            Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"You must specify a non-negative duration!");
            Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (Object)"You must specify a non-null unit!");
            this.whenLocatingServicesCacheResultsFor = unit.toMillis(duration);
            return this;
        }

        public Consultant build() {
            String consulHost;
            if (Strings.isNullOrEmpty((String)this.host)) {
                this.host = this.fromEnvironment("CONSUL_HOST");
            }
            if (Strings.isNullOrEmpty((String)(consulHost = this.host))) {
                consulHost = CONSUL_ADDRESS;
            }
            boolean changedConsulSchema = false;
            if (!consulHost.matches("[a-zA-Z0-9\\+\\-\\.]+://.*")) {
                consulHost = "http://" + consulHost;
                changedConsulSchema = true;
            }
            try {
                this.consulURI = new URI(consulHost);
                if (this.consulURI.getPort() == -1 && changedConsulSchema) {
                    this.consulURI = new URI(this.consulURI.getScheme(), this.consulURI.getUserInfo(), this.consulURI.getHost(), 8500, this.consulURI.getPath(), this.consulURI.getQuery(), this.consulURI.getFragment());
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("The specified CONSUL_HOST is not a valid URI: " + this.host, e);
            }
            this.serviceName = Optional.ofNullable(this.serviceName).orElse(this.fromEnvironment("SERVICE_NAME"));
            this.datacenter = Optional.ofNullable(this.datacenter).orElse(this.fromEnvironment("SERVICE_DC"));
            this.hostname = Optional.ofNullable(this.hostname).orElse(this.fromEnvironment("SERVICE_HOST"));
            this.instanceName = Optional.ofNullable(this.instanceName).orElse(Optional.ofNullable(this.fromEnvironment("SERVICE_INSTANCE")).orElse(UUID.randomUUID().toString()));
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
            }
            if (this.executor == null) {
                this.executor = new ScheduledThreadPoolExecutor(1);
            }
            if (this.http == null) {
                PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
                manager.setMaxTotal(5);
                manager.setDefaultMaxPerRoute(5);
                this.http = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)manager).build();
            }
            try (CloseableHttpResponse response = this.http.execute((HttpUriRequest)new HttpGet(this.consulURI + "/v1/agent/self"));){
                HttpEntity entity = response.getEntity();
                Agent agent = (Agent)this.mapper.readValue(entity.getContent(), Agent.class);
                Config config = agent.getConfig();
                if (Strings.isNullOrEmpty((String)this.datacenter)) {
                    this.datacenter = config.getDatacenter();
                }
                if (Strings.isNullOrEmpty((String)this.hostname)) {
                    this.hostname = config.getNodeName();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not fetch agent details from Consul.", e);
            }
            ServiceIdentifier id = new ServiceIdentifier(this.serviceName, this.datacenter, this.hostname, this.instanceName);
            Consultant consultant = new Consultant(this.executor, this.mapper, this.consulURI, id, this.settingListeners, this.configListeners, this.validator, this.http, this.pullConfig, this.healthEndpoint, this.kvPrefix, this.whenLocatingServicesCacheResultsFor);
            consultant.init(this.properties);
            return consultant;
        }

        private String fromEnvironment(String key) {
            String property = System.getProperty(key);
            if (property != null) {
                return property;
            }
            property = System.getenv(key);
            if (property != null) {
                return property;
            }
            return null;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Config {
            @JsonProperty(value="Datacenter")
            private String datacenter;
            @JsonProperty(value="NodeName")
            private String nodeName;

            public String getDatacenter() {
                return this.datacenter;
            }

            public String getNodeName() {
                return this.nodeName;
            }

            void setDatacenter(String datacenter) {
                this.datacenter = datacenter;
            }

            void setNodeName(String nodeName) {
                this.nodeName = nodeName;
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Agent {
            @JsonProperty(value="Config")
            private Config config;

            public Config getConfig() {
                return this.config;
            }

            void setConfig(Config config) {
                this.config = config;
            }
        }
    }
}

