/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import me.magnet.consultant.CheckStatus;
import me.magnet.consultant.Node;
import me.magnet.consultant.Service;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServiceInstance {
    @JsonProperty(value="Node")
    private final Node node;
    @JsonProperty(value="Service")
    private final Service service;
    @JsonProperty(value="Checks")
    private final List<CheckStatus> checks;

    private ServiceInstance() {
        this.node = null;
        this.service = null;
        this.checks = null;
    }

    ServiceInstance(Node node, Service service, List<CheckStatus> checks) {
        this.node = node;
        this.service = service;
        this.checks = checks;
    }

    public Node getNode() {
        return this.node;
    }

    public Service getService() {
        return this.service;
    }

    public List<CheckStatus> getChecks() {
        return ImmutableList.copyOf(this.checks);
    }

    public String toString() {
        return "[" + this.service.getService() + " - " + this.service.getId() + " @ " + this.node.getNode() + "]";
    }
}

