/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import me.magnet.consultant.ServiceIdentifier;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigWriter {
    private static final Logger log = LoggerFactory.getLogger(ConfigWriter.class);
    private final CloseableHttpClient httpClient;
    private final URI consulURI;
    private final String token;
    private final String kvPrefix;

    ConfigWriter(CloseableHttpClient httpClient, URI consulURI, String token, String kvPrefix) {
        this.httpClient = httpClient;
        this.consulURI = consulURI;
        this.token = token;
        this.kvPrefix = Optional.ofNullable(kvPrefix).orElse("config");
    }

    public boolean setConfig(ServiceIdentifier identifier, String key, String value) {
        try {
            if (value != null) {
                return this.put(identifier, key, value);
            }
            return this.delete(identifier, key);
        }
        catch (IOException | RuntimeException e) {
            log.error("Error occurred while pushing new config from Consul: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean put(ServiceIdentifier identifier, String key, String value) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.kvPrefix).append("/").append(identifier.getServiceName()).append("/");
        String identifierPrefix = this.createServiceIdentifierPrefix(identifier);
        if (!Strings.isNullOrEmpty((String)identifierPrefix)) {
            builder.append(identifierPrefix);
        }
        builder.append(key);
        String path = URLEncoder.encode(builder.toString(), "UTF-8");
        String url = this.consulURI + "/v1/kv/" + path;
        HttpPut request = new HttpPut(url);
        request.setEntity((HttpEntity)new StringEntity(value));
        if (!Strings.isNullOrEmpty((String)this.token)) {
            request.setHeader("X-Consul-Token", this.token);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            boolean bl = "true".equalsIgnoreCase(body);
            return bl;
        }
    }

    private boolean delete(ServiceIdentifier identifier, String key) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.kvPrefix).append("/").append(identifier.getServiceName()).append("/");
        String identifierPrefix = this.createServiceIdentifierPrefix(identifier);
        if (!Strings.isNullOrEmpty((String)identifierPrefix)) {
            builder.append(identifierPrefix);
        }
        builder.append(key);
        String path = URLEncoder.encode(builder.toString(), "UTF-8");
        String url = this.consulURI + "/v1/kv/" + path;
        HttpDelete request = new HttpDelete(url);
        if (!Strings.isNullOrEmpty((String)this.token)) {
            request.setHeader("X-Consul-Token", this.token);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            boolean bl = "true".equalsIgnoreCase(body);
            return bl;
        }
    }

    private String createServiceIdentifierPrefix(ServiceIdentifier identifier) {
        ArrayList parts = Lists.newArrayList();
        identifier.getDatacenter().map(value -> "dc=" + value).ifPresent(parts::add);
        identifier.getHostName().map(value -> "host=" + value).ifPresent(parts::add);
        identifier.getInstance().map(value -> "instance=" + value).ifPresent(parts::add);
        if (parts.isEmpty()) {
            return null;
        }
        return parts.stream().collect(Collectors.joining(",", "[", "]"));
    }
}

