/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import me.magnet.consultant.RoutingStrategy;
import me.magnet.consultant.ServiceInstance;
import me.magnet.consultant.ServiceInstanceBackend;
import me.magnet.consultant.ServiceLocator;

public class RoutingStrategies {
    public static final RoutingStrategy NETWORK_DISTANCE = (locator, serviceName) -> new ServiceLocator(() -> locator.listInstances(serviceName).iterator(), () -> {
        List<String> datacenters = locator.listDatacenters();
        Collections.reverse(datacenters);
        ServiceLocator current = null;
        for (String datacenter : datacenters) {
            boolean sameDatacenter = locator.getDatacenter().map(datacenter::equals).orElse(false);
            if (sameDatacenter) continue;
            if (current == null) {
                current = new ServiceLocator(() -> locator.listInstances(serviceName, datacenter).iterator());
                continue;
            }
            current = new ServiceLocator(() -> locator.listInstances(serviceName, datacenter).iterator(), current);
        }
        return current;
    });
    public static final RoutingStrategy RANDOMIZED_WEIGHTED_DISTANCE = RoutingStrategies.randomizedWeightedDistance(0.5);
    public static final RoutingStrategy ROUND_ROBIN = new RoutingStrategy(){
        private final Map<String, ServiceInstance> lastRequested = Maps.newConcurrentMap();

        @Override
        public ServiceLocator locateInstances(ServiceInstanceBackend serviceInstanceBackend, final String serviceName) {
            return NETWORK_DISTANCE.locateInstances(serviceInstanceBackend, serviceName).map(iterator -> {
                final ArrayList instances = Lists.newArrayList((Iterator)iterator);
                Comparator<ServiceInstance> comparing = Comparator.comparing(entry -> entry.getNode().getNode());
                comparing = comparing.thenComparing(instance -> instance.getService().getId());
                Collections.sort(instances, comparing);
                final HashSet attempted = Sets.newHashSet();
                return new Iterator<ServiceInstance>(){

                    @Override
                    public boolean hasNext() {
                        return attempted.size() < instances.size();
                    }

                    @Override
                    public ServiceInstance next() {
                        int start = 0;
                        ServiceInstance lastInstanceUsed = (ServiceInstance)lastRequested.get(serviceName);
                        if (lastInstanceUsed != null) {
                            start = instances.indexOf(lastInstanceUsed) + 1;
                        }
                        for (int i = start; i < start + instances.size(); ++i) {
                            ServiceInstance instance = (ServiceInstance)instances.get(i % instances.size());
                            if (!attempted.add(instance)) continue;
                            lastRequested.put(serviceName, instance);
                            return instance;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }).setListener(taken -> this.lastRequested.put(serviceName, (ServiceInstance)taken));
        }

        @Override
        public void reset() {
            this.lastRequested.clear();
        }
    };
    public static final RoutingStrategy RANDOMIZED = (serviceLocator, serviceName) -> NETWORK_DISTANCE.locateInstances(serviceLocator, serviceName).map(iterator -> {
        ArrayList instances = Lists.newArrayList((Iterator)iterator);
        Collections.shuffle(instances);
        return instances.iterator();
    });

    public static RoutingStrategy randomizedWeightedDistance(final double threshold) {
        return new RoutingStrategy(){
            private final Random random = new Random();

            @Override
            public ServiceLocator locateInstances(ServiceInstanceBackend serviceInstanceBackend, String serviceName) {
                return NETWORK_DISTANCE.locateInstances(serviceInstanceBackend, serviceName).map(iterator -> {
                    ArrayList instances = Lists.newArrayList((Iterator)iterator);
                    if (instances.size() <= 1) {
                        return instances.iterator();
                    }
                    ArrayList reordered = Lists.newArrayList();
                    while (!instances.isEmpty()) {
                        int index;
                        for (index = 0; this.random.nextDouble() < threshold && index < instances.size() - 1; ++index) {
                        }
                        reordered.add((ServiceInstance)instances.remove(index));
                    }
                    return reordered.iterator();
                });
            }
        };
    }

    private RoutingStrategies() {
    }
}

