/*
 * Decompiled with CFR 0.152.
 */
package me.magnet.consultant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.magnet.consultant.CheckStatus;
import me.magnet.consultant.ConfigUpdater;
import me.magnet.consultant.ConsulException;
import me.magnet.consultant.ConsultantException;
import me.magnet.consultant.ServiceInstance;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceBackend {
    private static final Logger log = LoggerFactory.getLogger(ConfigUpdater.class);
    private static final TypeReference<List<ServiceInstance>> TYPES = new TypeReference<List<ServiceInstance>>(){};
    private final Optional<String> datacenter;
    private final LoadingCache<ServiceIdentifierCacheKey, List<ServiceInstance>> serviceInstances;
    private final Supplier<List<String>> datacenters;

    ServiceInstanceBackend(Optional<String> datacenter, URI consulUri, String token, ObjectMapper objectMapper, CloseableHttpClient http, long cacheLocateCallsForMillis) {
        this.datacenter = datacenter;
        this.serviceInstances = CacheBuilder.newBuilder().expireAfterWrite(cacheLocateCallsForMillis, TimeUnit.MILLISECONDS).build(CacheLoader.from(key -> {
            String url = consulUri + "/v1/health/service/" + key.getServiceName() + "?near=_agent";
            if (!Strings.isNullOrEmpty((String)key.getDatacenter())) {
                url = url + "&dc=" + key.getDatacenter();
            }
            HttpGet request = new HttpGet(url);
            request.setHeader("User-Agent", "Consultant");
            if (!Strings.isNullOrEmpty((String)token)) {
                request.setHeader("X-Consul-Token", token);
            }
            try {
                CloseableHttpResponse response = http.execute((HttpUriRequest)request);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 400) {
                        InputStream content = response.getEntity().getContent();
                        List allInstances = (List)objectMapper.readValue(content, TYPES);
                        List passingInstances = allInstances.stream().filter(instance -> instance.getChecks().stream().allMatch(checkStatus -> "passing".equals(checkStatus.getStatus()))).collect(Collectors.toList());
                        if (passingInstances.isEmpty() && !allInstances.isEmpty()) {
                            StringBuilder builder = new StringBuilder();
                            builder.append("None of the known instances are passing all of their checks: \n");
                            for (ServiceInstance instance2 : allInstances) {
                                String name = instance2.getService().getService();
                                String nodeName = instance2.getNode().getNode();
                                builder.append("\tService \"").append(name).append("\" on node \"").append(nodeName).append("\":\n");
                                for (CheckStatus checkStatus : instance2.getChecks()) {
                                    builder.append("\t\t- Check \"").append(checkStatus.getName()).append("\" has status \"").append(checkStatus.getStatus()).append("\" with output: ").append(checkStatus.getOutput()).append("\n");
                                }
                            }
                            log.warn(builder.toString());
                        }
                        List list = passingInstances;
                        return list;
                    }
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new ConsultantException("Could not locate service: " + key.getServiceName(), new ConsulException(statusCode, body));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response != null) {
                        ServiceInstanceBackend.$closeResource(throwable, (AutoCloseable)response);
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                throw new ConsultantException(e);
            }
        }));
        this.datacenters = Suppliers.memoizeWithExpiration(() -> {
            String url = consulUri + "/v1/catalog/datacenters";
            HttpGet request = new HttpGet(url);
            request.setHeader("User-Agent", "Consultant");
            if (!Strings.isNullOrEmpty((String)token)) {
                request.setHeader("X-Consul-Token", token);
            }
            try {
                CloseableHttpResponse response = http.execute((HttpUriRequest)request);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 400) {
                        InputStream content = response.getEntity().getContent();
                        List list = (List)objectMapper.readValue(content, (TypeReference)new TypeReference<List<String>>(){});
                        return list;
                    }
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new ConsultantException("Could not locate datacenters", new ConsulException(statusCode, body));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response != null) {
                        ServiceInstanceBackend.$closeResource(throwable, (AutoCloseable)response);
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                throw new ConsultantException(e);
            }
        }, (long)cacheLocateCallsForMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    public List<ServiceInstance> listInstances(String serviceName) {
        return this.listInstances(serviceName, null);
    }

    public List<ServiceInstance> listInstances(String serviceName, String datacenter) {
        try {
            return (List)this.serviceInstances.get((Object)new ServiceIdentifierCacheKey(datacenter, serviceName));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public List<String> listDatacenters() {
        return (List)this.datacenters.get();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static class ServiceIdentifierCacheKey {
        private final String datacenter;
        private final String serviceName;

        private ServiceIdentifierCacheKey(String datacenter, String serviceName) {
            this.datacenter = datacenter;
            this.serviceName = serviceName;
        }

        public String getDatacenter() {
            return this.datacenter;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public boolean equals(Object other) {
            if (other instanceof ServiceIdentifierCacheKey) {
                ServiceIdentifierCacheKey otherKey = (ServiceIdentifierCacheKey)other;
                return new EqualsBuilder().append((Object)this.datacenter, (Object)otherKey.datacenter).append((Object)this.serviceName, (Object)otherKey.serviceName).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.datacenter).append((Object)this.serviceName).toHashCode();
        }

        public String toString() {
            if (this.datacenter != null) {
                return this.datacenter + "-" + this.serviceName;
            }
            return this.serviceName;
        }
    }
}

