package me.matsumo.fankt.fanbox.datasource.db

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import me.matsumo.fankt.fanbox.domain.model.db.CSRFToken

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
internal class TokenDao_Impl(
  __db: RoomDatabase,
) : TokenDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfCSRFToken: EntityInsertAdapter<CSRFToken>
  init {
    this.__db = __db
    this.__insertAdapterOfCSRFToken = object : EntityInsertAdapter<CSRFToken>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `fankt_csrf_tokens` (`id`,`value`,`createdAt`) VALUES (nullif(?, 0),?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: CSRFToken) {
        statement.bindLong(1, entity.id)
        statement.bindText(2, entity.value)
        statement.bindLong(3, entity.createdAt)
      }
    }
  }

  public override suspend fun insert(token: CSRFToken): Unit = performSuspending(__db, false, true)
      { _connection ->
    __insertAdapterOfCSRFToken.insert(_connection, token)
  }

  public override suspend fun getAllTokens(): List<CSRFToken> {
    val _sql: String = "SELECT * FROM fankt_csrf_tokens"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _cursorIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _cursorIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _cursorIndexOfCreatedAt: Int = getColumnIndexOrThrow(_stmt, "createdAt")
        val _result: MutableList<CSRFToken> = mutableListOf()
        while (_stmt.step()) {
          val _item: CSRFToken
          val _tmpId: Long
          _tmpId = _stmt.getLong(_cursorIndexOfId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_cursorIndexOfValue)
          val _tmpCreatedAt: Long
          _tmpCreatedAt = _stmt.getLong(_cursorIndexOfCreatedAt)
          _item = CSRFToken(_tmpId,_tmpValue,_tmpCreatedAt)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun getLatestToken(): Flow<CSRFToken?> {
    val _sql: String = "SELECT * FROM fankt_csrf_tokens ORDER BY createdAt DESC LIMIT 1"
    return createFlow(__db, false, arrayOf("fankt_csrf_tokens")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _cursorIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _cursorIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _cursorIndexOfCreatedAt: Int = getColumnIndexOrThrow(_stmt, "createdAt")
        val _result: CSRFToken?
        if (_stmt.step()) {
          val _tmpId: Long
          _tmpId = _stmt.getLong(_cursorIndexOfId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_cursorIndexOfValue)
          val _tmpCreatedAt: Long
          _tmpCreatedAt = _stmt.getLong(_cursorIndexOfCreatedAt)
          _result = CSRFToken(_tmpId,_tmpValue,_tmpCreatedAt)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: String) {
    val _sql: String = "DELETE FROM fankt_csrf_tokens WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun clear() {
    val _sql: String = "DELETE FROM fankt_csrf_tokens"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
