/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.IOService;
import me.melchor9000.net.Procedure;

public class FutureImpl<ReturnType>
implements Future<ReturnType> {
    private final AtomicBoolean done = new AtomicBoolean();
    private volatile boolean successful;
    private volatile boolean cancelled;
    private volatile Throwable cause;
    private volatile ReturnType returnValue;
    private List<Callback<Future<ReturnType>>> listeners = new ArrayList<Callback<Future<ReturnType>>>();
    private Lock lock = new ReentrantLock(true);
    private Condition waitDone = this.lock.newCondition();
    private final IOService service;
    private final Procedure whenCancelled;
    private Future<?> timeoutFuture;

    public FutureImpl(IOService service, Procedure whenCancelled) {
        this.service = service;
        this.whenCancelled = whenCancelled;
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        boolean done = this.done.get();
        this.lock.unlock();
        return done;
    }

    @Override
    public boolean isSuccessful() {
        this.lock.lock();
        boolean done = this.done.get();
        boolean successful = this.successful;
        this.lock.unlock();
        return done && successful;
    }

    @Override
    public boolean isCancelled() {
        this.lock.lock();
        boolean done = this.done.get();
        boolean cancelled = this.cancelled;
        this.lock.unlock();
        return done && cancelled;
    }

    @Override
    public boolean isCancelable() {
        return this.whenCancelled != null;
    }

    @Override
    public void cancel(boolean mayInterrupt) {
        this.lock.lock();
        if (!this.cancelled && !this.done.get()) {
            this.whenCancelled.call();
            this.cancelled = true;
            this.done.set(true);
        }
        this.lock.unlock();
    }

    @Override
    public Future<ReturnType> whenDone(Callback<Future<ReturnType>> cbk) {
        this.lock.lock();
        if (!this.done.get()) {
            this.listeners.add(cbk);
            this.lock.unlock();
        } else {
            this.lock.unlock();
            try {
                cbk.call(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public Future<ReturnType> setTimeout(long milliseconds) {
        if (milliseconds <= 0L) {
            throw new IllegalArgumentException("Only positive non 0 values are accepted");
        }
        if (this.isDone()) {
            throw new IllegalStateException("The task is done");
        }
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.timeoutFuture = this.service.schedule(new Procedure(){

            @Override
            public void call() {
                FutureImpl.this.cancel(true);
                FutureImpl.this.postError(new CancellationException("Task was cancelled by a timeout"));
            }
        }, milliseconds);
        return this;
    }

    @Override
    public ReturnType getValueNow() {
        this.lock.lock();
        ReturnType t = this.returnValue;
        this.lock.unlock();
        return t;
    }

    @Override
    public Throwable cause() {
        this.lock.lock();
        Throwable t = this.cause;
        this.lock.unlock();
        return t;
    }

    @Override
    public ReturnType getValue(long millis) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done.get()) {
            this.lock.lock();
            this.waitDone.await(millis, TimeUnit.MILLISECONDS);
            this.lock.unlock();
        }
        if (!this.isSuccessful()) {
            throw new ExecutionException(this.cause);
        }
        return this.returnValue;
    }

    @Override
    public ReturnType getValueUninterrumptibly(long millis) throws ExecutionException, TimeoutException {
        ReturnType ret = null;
        if (!this.done.get()) {
            long currentMillis = System.currentTimeMillis();
            while (!this.isDone()) {
                try {
                    ret = this.getValue(millis);
                }
                catch (InterruptedException ignore) {
                    millis -= System.currentTimeMillis() - currentMillis;
                }
            }
        } else {
            ret = this.returnValue;
        }
        if (!this.isSuccessful()) {
            throw new ExecutionException(this.cause);
        }
        return ret;
    }

    @Override
    public ReturnType getValue() throws ExecutionException, InterruptedException {
        if (!this.done.get()) {
            this.lock.lock();
            this.waitDone.await();
            this.lock.unlock();
        }
        if (!this.isSuccessful()) {
            throw new ExecutionException(this.cause);
        }
        return this.returnValue;
    }

    @Override
    public ReturnType getValueUninterrumptibly() throws ExecutionException, InterruptedException {
        if (!this.done.get()) {
            this.lock.lock();
            this.waitDone.awaitUninterruptibly();
            this.lock.unlock();
        }
        if (!this.isSuccessful()) {
            throw new ExecutionException(this.cause);
        }
        return this.returnValue;
    }

    @Override
    public Future<ReturnType> sync() {
        if (!this.done.get()) {
            this.lock.lock();
            this.waitDone.awaitUninterruptibly();
            this.lock.unlock();
            if (!this.isSuccessful()) {
                this.doThrow(new ExecutionException(this.cause));
            }
        }
        return this;
    }

    public void postSuccess(ReturnType result) {
        this.lock.lock();
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.returnValue = result;
        this.successful = true;
        this.done.set(true);
        this.lock.unlock();
        this.executeListeners();
        this.lock.lock();
        this.waitDone.signalAll();
        this.lock.unlock();
    }

    public void postError(Throwable cause) {
        this.lock.lock();
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.cause = cause;
        this.done.set(true);
        this.lock.unlock();
        this.executeListeners();
        this.lock.lock();
        this.waitDone.signalAll();
        this.lock.unlock();
    }

    private void executeListeners() {
        for (Callback<Future<ReturnType>> cbk : this.listeners) {
            try {
                cbk.call(this);
            }
            catch (Throwable t) {
                System.err.println("Caught a Throwable inside a whenDone() Callback");
                t.printStackTrace();
            }
        }
    }

    private void doThrow(Exception e) {
        FutureImpl.doThrow0(e);
    }

    private static <E extends Exception> void doThrow0(Exception e) throws E {
        throw e;
    }
}

