/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.melchor9000.net.Callback;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.Procedure;
import me.melchor9000.net.Serializable;
import me.melchor9000.net.Socket;

public class UDPSocket
extends Socket {
    private DatagramChannel socket;
    private ConcurrentLinkedQueue<DatagramPacket> receivedPackets;
    private ConcurrentLinkedQueue<ReadOperation> readOperations;
    private ReadManager readManager;
    private volatile boolean canReadDirectly = false;

    public UDPSocket(IOService service) {
        this(service, StandardProtocolFamily.INET);
    }

    public UDPSocket(IOService service, ProtocolFamily ip) {
        super(service);
        ((Bootstrap)this.bootstrap.channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{UDPSocket.this.readManager});
            }
        });
        this.readOperations = new ConcurrentLinkedQueue();
        this.receivedPackets = new ConcurrentLinkedQueue();
        this.readManager = new ReadManager();
    }

    @Override
    public void bind(SocketAddress local) {
        super.bind(local);
        this.socket = (DatagramChannel)this.channel;
    }

    @Override
    public void connect(SocketAddress endpoint) throws InterruptedException {
        super.connect(endpoint);
        this.socket = (DatagramChannel)this.channel;
    }

    @Override
    public Future<Void> connectAsync(SocketAddress endpoint) {
        return super.connectAsync(endpoint).whenDone(new Callback<Future<Void>>(){

            @Override
            public void call(Future<Void> arg) {
                UDPSocket.this.socket = (DatagramChannel)UDPSocket.this.channel;
            }
        });
    }

    public long sendTo(ByteBuf data, int bytes, InetSocketAddress endpoint) {
        this.sendAsyncTo(data, bytes, endpoint).sync();
        return bytes;
    }

    public long sendTo(ByteBuf data, InetSocketAddress endpoint) {
        return this.sendTo(data, data.readableBytes(), endpoint);
    }

    public Future<Void> sendAsyncTo(ByteBuf data, int bytes, InetSocketAddress endpoint) {
        this.checkSocketCreated("sendAsyncTo");
        final ByteBuf buff = this.channel.alloc().directBuffer(bytes).retain();
        buff.writeBytes(data, bytes);
        return this.createFuture(this.channel.writeAndFlush((Object)new DatagramPacket(buff, endpoint)).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                buff.release();
            }
        }));
    }

    public Future<Void> sendAsyncTo(ByteBuf data, InetSocketAddress endpoint) {
        return this.sendAsyncTo(data, data.readableBytes(), endpoint);
    }

    @Override
    public long receive(ByteBuf data, int bytes) throws Throwable {
        return this.receiveFrom((ByteBuf)data, (int)bytes).bytes;
    }

    public Packet receiveFrom(ByteBuf data, int bytes) throws Throwable {
        this.checkSocketCreated("receiveFrom");
        if (this.canReadDirectly) {
            if (((ByteBuf)this.receivedPackets.peek().content()).readableBytes() > bytes) {
                throw new NotEnoughSpaceForPacketException("Cannot write the message into the ByteBuf", ((ByteBuf)this.receivedPackets.peek().content()).readableBytes(), (InetSocketAddress)this.receivedPackets.peek().sender());
            }
            DatagramPacket packet = this.receivedPackets.poll();
            int bytes2 = ((ByteBuf)packet.content()).writableBytes();
            ((ByteBuf)packet.content()).writeBytes(data, ((ByteBuf)packet.content()).writableBytes());
            this.canReadDirectly = false;
            packet.release();
            return new Packet(data, (InetSocketAddress)packet.sender(), bytes2);
        }
        return this.receiveAsyncFrom(data, bytes).sync().getValueNow();
    }

    public Packet receiveFrom(ByteBuf data) throws Throwable {
        return this.receiveFrom(data, data.writableBytes());
    }

    @Override
    public Future<Long> receiveAsync(ByteBuf data, int bytes) {
        final Future[] leFuture = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        final FutureImpl<Long> future = this.createFuture(new Procedure(){

            @Override
            public void call() {
                leFuture[0].cancel(true);
            }
        });
        leFuture[0] = this.receiveAsyncFrom(data, bytes).whenDone(new Callback<Future<Packet>>(){

            @Override
            public void call(Future<Packet> arg) {
                if (arg.isSuccessful()) {
                    future.postSuccess(Long.valueOf(arg.getValueNow().bytes));
                } else {
                    future.postError(arg.cause());
                }
            }
        });
        return future;
    }

    public Future<Packet> receiveAsyncFrom(ByteBuf data, int bytes) {
        this.checkSocketCreated("receiveAsyncFrom");
        final ReadOperation[] op = new ReadOperation[1];
        FutureImpl<Packet> future = this.createFuture(new Procedure(){

            @Override
            public void call() {
                UDPSocket.this.readOperations.remove(op[0]);
            }
        });
        this.channel.read();
        op[0] = new ReadOperation(future, bytes, data);
        this.readOperations.add(op[0]);
        if (!this.receivedPackets.isEmpty()) {
            try {
                this.readManager.checkAndSendData();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return future;
    }

    public Future<Packet> receiveAsyncFrom(ByteBuf data) {
        return this.receiveAsyncFrom(data, data.writableBytes());
    }

    public Future<Void> sendAsync(Serializable data) {
        return this.sendAsync(data.toByteBuf());
    }

    public long send(Serializable data) throws InterruptedException {
        return this.send(data.toByteBuf());
    }

    public Future<Void> sendAsyncTo(String data, InetSocketAddress remoteEndpoint) {
        return this.sendAsyncTo(Unpooled.wrappedBuffer((byte[])data.getBytes()), remoteEndpoint);
    }

    public Future<Void> sendAsyncTo(Serializable data, InetSocketAddress remoteEndpoint) {
        return this.sendAsyncTo(data.toByteBuf(), remoteEndpoint);
    }

    public long sendTo(String data, InetSocketAddress remoteEndpoint) throws InterruptedException {
        return this.sendTo(Unpooled.wrappedBuffer((byte[])data.getBytes()), remoteEndpoint);
    }

    public long sendTo(Serializable data, InetSocketAddress remoteEndpoint) throws InterruptedException {
        return this.sendTo(data.toByteBuf(), remoteEndpoint);
    }

    public <Type extends Serializable> Future<Type> receiveAsync(final Type data) {
        final ByteBuf b = Unpooled.buffer((int)1500).retain();
        final Future[] leFuture = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        final FutureImpl future = this.createFuture(new Procedure(){

            @Override
            public void call() {
                leFuture[0].cancel(true);
            }
        });
        leFuture[0] = this.receiveAsync((Type)b).whenDone((Callback<Future<ByteBuf>>)new Callback<Future<Long>>(){

            @Override
            public void call(Future<Long> arg) {
                block6: {
                    try {
                        if (arg.isSuccessful()) {
                            try {
                                data.fromByteBuf(b);
                            }
                            catch (DataNotRepresentsObject e) {
                                future.postError(e);
                            }
                            future.postSuccess(data);
                            break block6;
                        }
                        future.postError(arg.cause());
                    }
                    finally {
                        b.release();
                    }
                }
            }
        });
        return future;
    }

    public <Type extends Serializable> Future<Packet> receiveAsyncFrom(final Type data) {
        final ByteBuf b = Unpooled.buffer((int)1500).retain();
        final Future[] leFuture = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        final FutureImpl<Packet> future = this.createFuture(new Procedure(){

            @Override
            public void call() {
                leFuture[0].cancel(true);
            }
        });
        leFuture[0] = this.receiveAsyncFrom((Type)b).whenDone(new Callback<Future<Packet>>(){

            @Override
            public void call(Future<Packet> arg) {
                block6: {
                    try {
                        if (arg.isSuccessful()) {
                            try {
                                data.fromByteBuf(b);
                            }
                            catch (DataNotRepresentsObject e) {
                                future.postError(e);
                            }
                            future.postSuccess(arg.getValueNow());
                            break block6;
                        }
                        future.postError(arg.cause());
                    }
                    finally {
                        b.release();
                    }
                }
            }
        });
        return future;
    }

    public void receive(Serializable data) throws Throwable {
        ByteBuf b = Unpooled.buffer((int)1500);
        Packet p = this.receiveFrom(b);
        data.fromByteBuf(b);
    }

    public Packet receiveFrom(Serializable data) throws Throwable {
        ByteBuf b = Unpooled.buffer((int)1500);
        Packet p = this.receiveFrom(b);
        data.fromByteBuf(b);
        return p;
    }

    public static class NotEnoughSpaceForPacketException
    extends Exception {
        private long bytes;
        private InetSocketAddress remoteEndpoint;

        private NotEnoughSpaceForPacketException(String message, long bytes, InetSocketAddress end) {
            super(message);
            this.bytes = bytes;
            this.remoteEndpoint = end;
        }

        public long getReceivedPacketSize() {
            return this.bytes;
        }

        public InetSocketAddress getRemoteEndpoint() {
            return this.remoteEndpoint;
        }
    }

    public class Packet {
        public final ByteBuf data;
        public final InetSocketAddress remoteEndpoint;
        public final int bytes;

        private Packet(ByteBuf data, InetSocketAddress remoteEndpoint, int bytes) {
            this.data = data;
            this.remoteEndpoint = remoteEndpoint;
            this.bytes = bytes;
        }
    }

    private class ReadOperation {
        private FutureImpl<Packet> cbk;
        private int bytesToRead;
        private ByteBuf buffer;

        private ReadOperation(FutureImpl<Packet> cbk, int bytesToRead, ByteBuf buffer) {
            this.cbk = cbk;
            this.bytesToRead = bytesToRead;
            this.buffer = buffer;
        }
    }

    private class ReadManager
    extends ChannelInboundHandlerAdapter {
        private ReadManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            DatagramPacket message = (DatagramPacket)msg;
            UDPSocket.this.bytesRead += (long)((ByteBuf)message.content()).readableBytes();
            UDPSocket.this.receivedPackets.add(message);
            try {
                this.checkAndSendData();
            }
            finally {
                UDPSocket.this.fireReceivedData();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndSendData() throws Exception {
            while (this.hasEnoughData()) {
                ReadOperation op = (ReadOperation)UDPSocket.this.readOperations.poll();
                if (((ByteBuf)((DatagramPacket)UDPSocket.this.receivedPackets.peek()).content()).readableBytes() <= op.bytesToRead) {
                    DatagramPacket packet = (DatagramPacket)UDPSocket.this.receivedPackets.poll();
                    try {
                        int bytes = ((ByteBuf)packet.content()).readableBytes();
                        ((ByteBuf)packet.content()).readBytes(op.buffer, bytes);
                        op.cbk.postSuccess(new Packet(op.buffer, (InetSocketAddress)packet.sender(), bytes));
                        continue;
                    }
                    finally {
                        packet.release();
                        continue;
                    }
                }
                UDPSocket.this.canReadDirectly = true;
                op.cbk.postError(new NotEnoughSpaceForPacketException("Cannot write message into your buffer", ((ByteBuf)((DatagramPacket)UDPSocket.this.receivedPackets.peek()).content()).readableBytes(), (InetSocketAddress)((DatagramPacket)UDPSocket.this.receivedPackets.peek()).sender()));
                if (UDPSocket.this.canReadDirectly) {
                    ((DatagramPacket)UDPSocket.this.receivedPackets.poll()).release();
                }
                UDPSocket.this.canReadDirectly = false;
            }
        }

        private boolean hasEnoughData() {
            return !UDPSocket.this.readOperations.isEmpty() && !UDPSocket.this.receivedPackets.isEmpty();
        }
    }
}

