/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.resolver.DNSResourceData;

public class DNSA
extends DNSResourceData {
    private Inet4Address address;

    public Inet4Address getAddress() {
        return this.address;
    }

    public void setAddress(Inet4Address address) {
        this.address = address;
    }

    public void setAddress(byte a1, byte a2, byte a3, byte a4) {
        this.setAddress(new byte[]{a1, a2, a3, a4});
    }

    public void setAddress(byte[] address) {
        try {
            this.address = (Inet4Address)Inet4Address.getByAddress(address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    DNSA(ByteBuf data) {
        super(data);
    }

    @Override
    public int byteBufSize() {
        return 4;
    }

    @Override
    public void toByteBuf(ByteBuf buffer) {
        buffer.writeBytes(this.address.getAddress());
    }

    @Override
    public void fromByteBuf(ByteBuf buffer) throws DataNotRepresentsObject {
        byte[] ip = new byte[4];
        buffer.readBytes(ip);
        try {
            this.address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.address.toString();
    }
}

