/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.directory.InitialDirContext;
import me.melchor9000.net.resolver.DNSA;
import me.melchor9000.net.resolver.DNSAAAA;
import me.melchor9000.net.resolver.DNSCNAME;
import me.melchor9000.net.resolver.DNSResourceRecord;

public class DNSResolverCache {
    private static Map<String, Set<Entry<InetAddress>>> cache = new TreeMap<String, Set<Entry<InetAddress>>>();
    private static Map<String, Entry<String>> alias = new TreeMap<String, Entry<String>>();

    public static List<InetSocketAddress> dnsServers() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            InitialDirContext ictx = new InitialDirContext(env);
            String dnsServers = (String)ictx.getEnvironment().get("java.naming.provider.url");
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            for (String dnsUrl : dnsServers.split(" ")) {
                try {
                    dnsUrl = dnsUrl.replace("dns://", "");
                    String[] parts = dnsUrl.split(":");
                    addresses.add(new InetSocketAddress(InetAddress.getByName(parts[0]), parts.length == 2 ? Integer.parseInt(parts[1]) : 53));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return addresses;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    static Iterable<InetAddress> getAddresses(String name) {
        DNSResolverCache.clear(name);
        if (cache.containsKey(name)) {
            HashSet<InetAddress> out = new HashSet<InetAddress>();
            for (Entry<InetAddress> e : cache.get(name)) {
                out.add((InetAddress)((Entry)e).value);
            }
            return out;
        }
        if (alias.containsKey(name)) {
            return DNSResolverCache.getAddresses((String)((Entry)alias.get(name)).value);
        }
        return null;
    }

    static void addAEntry(String name, DNSResourceRecord record) {
        DNSResolverCache.clear(name);
        if (!cache.containsKey(name)) {
            cache.put(name, new HashSet());
        }
        cache.get(name).add(new Entry(((DNSA)record.getData()).getAddress(), record.getTtl()));
    }

    static void addAAAAEntry(String name, DNSResourceRecord record) {
        DNSResolverCache.clear(name);
        if (!cache.containsKey(name)) {
            cache.put(name, new TreeSet());
        }
        cache.get(name).add(new Entry(((DNSAAAA)record.getData()).getAddress(), record.getTtl()));
    }

    static void addCNAMEEntry(String name, DNSResourceRecord record) {
        alias.put(name, new Entry(((DNSCNAME)record.getData()).getCname(), record.getTtl()));
    }

    private static void clear(String name) {
        if (cache.containsKey(name)) {
            Iterator<Entry<InetAddress>> it = cache.get(name).iterator();
            while (it.hasNext()) {
                if (((Entry)it.next()).isValid()) continue;
                it.remove();
            }
        }
        if (alias.containsKey(name) && !((Entry)DNSResolverCache.alias.get(name)).isValid()) {
            alias.remove(name);
        }
    }

    private static class Entry<Value> {
        private Value value;
        private long endLive;

        private Entry(Value value, long ttl) {
            this.value = value;
            this.endLive = (System.currentTimeMillis() / 1000L + ttl) * 1000L;
        }

        private boolean isValid() {
            return System.currentTimeMillis() < this.endLive;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return e.value.equals(e) && e.endLive == this.endLive;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode() * 7 + (int)this.endLive;
        }
    }
}

