/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.IOService;
import me.melchor9000.net.Procedure;

class NettyFuture<ReturnType>
implements Future<ReturnType> {
    private final io.netty.util.concurrent.Future<ReturnType> future;
    private final IOService service;
    private final Procedure whenCancelled;
    private Future<?> timeoutFuture;

    NettyFuture(io.netty.util.concurrent.Future<ReturnType> future, IOService service, Procedure whenCancelled) {
        this.future = future;
        this.service = service;
        this.whenCancelled = whenCancelled;
        future.addListener(new GenericFutureListener<io.netty.util.concurrent.Future<? super ReturnType>>(){

            public void operationComplete(io.netty.util.concurrent.Future<? super ReturnType> future) throws Exception {
                if (NettyFuture.this.timeoutFuture != null) {
                    NettyFuture.this.timeoutFuture.cancel(false);
                }
            }
        });
    }

    NettyFuture(io.netty.util.concurrent.Future<ReturnType> future, IOService service) {
        this(future, service, null);
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean isSuccessful() {
        return this.future.isSuccess();
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isCancelable() {
        return this.future.isCancellable();
    }

    @Override
    public void cancel(boolean mayInterrupt) {
        this.future.cancel(mayInterrupt);
    }

    @Override
    public Future<ReturnType> whenDone(final Callback<Future<ReturnType>> cbk) {
        if (cbk == null) {
            throw new NullPointerException("Callback cannot be null");
        }
        this.future.addListener(new GenericFutureListener<io.netty.util.concurrent.Future<? super ReturnType>>(){

            public void operationComplete(io.netty.util.concurrent.Future<? super ReturnType> future) throws Exception {
                try {
                    cbk.call(NettyFuture.this);
                }
                catch (Exception exception) {
                    throw exception;
                }
                catch (Throwable throwable) {
                    System.err.println("Caught a Throwable in " + cbk.getClass().getName() + ".call()");
                    throwable.printStackTrace();
                }
            }
        });
        return this;
    }

    @Override
    public Future<ReturnType> setTimeout(long milliseconds) {
        if (milliseconds <= 0L) {
            throw new IllegalArgumentException("Only positive non 0 values are accepted");
        }
        if (this.isDone()) {
            throw new IllegalStateException("The task is done");
        }
        if (!this.isCancelable()) {
            throw new IllegalStateException("The task is not cancellable");
        }
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.timeoutFuture = this.service.schedule(new Procedure(){

            @Override
            public void call() {
                if (!NettyFuture.this.isDone()) {
                    if (NettyFuture.this.whenCancelled != null) {
                        NettyFuture.this.whenCancelled.call();
                    }
                    NettyFuture.this.cancel(true);
                }
            }
        }, milliseconds);
        return this;
    }

    @Override
    public ReturnType getValueNow() {
        return (ReturnType)this.future.getNow();
    }

    @Override
    public Throwable cause() {
        return this.future.cause();
    }

    @Override
    public ReturnType getValue(long millis) throws InterruptedException, ExecutionException, TimeoutException {
        return (ReturnType)this.future.get(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ReturnType getValueUninterrumptibly(long millis) throws ExecutionException, TimeoutException {
        ReturnType ret = null;
        long currentMillis = System.currentTimeMillis();
        while (!this.isDone()) {
            try {
                ret = this.getValue(millis);
            }
            catch (InterruptedException ignore) {
                millis -= System.currentTimeMillis() - currentMillis;
            }
        }
        return ret;
    }

    @Override
    public ReturnType getValue() throws ExecutionException, InterruptedException {
        return (ReturnType)this.future.get();
    }

    @Override
    public ReturnType getValueUninterrumptibly() throws ExecutionException, InterruptedException {
        ReturnType ret = null;
        while (!this.isDone()) {
            try {
                ret = this.getValue();
            }
            catch (InterruptedException interruptedException) {}
        }
        return ret;
    }

    @Override
    public Future<ReturnType> sync() {
        this.future.syncUninterruptibly();
        return this;
    }
}

