/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.resolver.DNSResourceData;

public class DNSA
extends DNSResourceData {
    private Inet4Address address;

    public Inet4Address getAddress() {
        return this.address;
    }

    public void setAddress(Inet4Address address) {
        this.address = address;
    }

    public void setAddress(int a1, int a2, int a3, int a4) {
        this.setAddress(new byte[]{(byte)a1, (byte)a2, (byte)a3, (byte)a4});
    }

    public void setAddress(byte[] address) {
        try {
            this.address = (Inet4Address)Inet4Address.getByAddress(address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    DNSA(ByteBuf data) {
        super(data);
    }

    @Override
    public int byteBufSize() {
        return 4;
    }

    @Override
    public void toByteBuf(ByteBuf buffer) {
        buffer.writeBytes(this.address.getAddress());
    }

    @Override
    public void fromByteBuf(ByteBuf buffer) throws DataNotRepresentsObject {
        if (buffer.readableBytes() < 4) {
            throw new DataNotRepresentsObject("DNS RR type A doesn't contain data", buffer);
        }
        byte[] ip = new byte[4];
        buffer.readBytes(ip);
        try {
            this.address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.address.toString();
    }
}

