/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.directory.InitialDirContext;
import me.melchor9000.net.resolver.DNSA;
import me.melchor9000.net.resolver.DNSAAAA;
import me.melchor9000.net.resolver.DNSCNAME;
import me.melchor9000.net.resolver.DNSResourceRecord;

public class DNSResolverCache {
    private static Map<String, Set<Entry<InetAddress>>> cache4 = new TreeMap<String, Set<Entry<InetAddress>>>();
    private static Map<String, Set<Entry<InetAddress>>> cache6 = new TreeMap<String, Set<Entry<InetAddress>>>();
    private static Map<String, Entry<String>> alias = new TreeMap<String, Entry<String>>();

    public static List<InetSocketAddress> dnsServers() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            InitialDirContext ictx = new InitialDirContext(env);
            String dnsServers = (String)ictx.getEnvironment().get("java.naming.provider.url");
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            for (String dnsUrl : dnsServers.split(" ")) {
                try {
                    dnsUrl = dnsUrl.replace("dns://", "");
                    String[] parts = dnsUrl.split(":");
                    addresses.add(new InetSocketAddress(InetAddress.getByName(parts[0]), parts.length == 2 ? Integer.parseInt(parts[1]) : 53));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return addresses;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    static Iterable<InetAddress> getAddresses(String name) {
        DNSResolverCache.clear(name);
        Set<InetAddress> ret = null;
        Set<InetAddress> v4 = DNSResolverCache.getAddresses(name, cache4);
        Set<InetAddress> v6 = DNSResolverCache.getAddresses(name, cache6);
        if (v4 != null) {
            ret = v4;
            if (v6 != null) {
                ret.addAll(v6);
            }
        } else if (v6 != null) {
            ret = v6;
        }
        return ret;
    }

    static Iterable<InetAddress> getAddressesIPv4(String name) {
        DNSResolverCache.clear(name);
        return DNSResolverCache.getAddresses(name, cache4);
    }

    static Iterable<InetAddress> getAddressesIPv6(String name) {
        DNSResolverCache.clear(name);
        return DNSResolverCache.getAddresses(name, cache6);
    }

    static boolean hasIPv4(String name) {
        DNSResolverCache.clear(name);
        return cache4.containsKey(name) || alias.containsKey(name) && DNSResolverCache.hasIPv4((String)((Entry)alias.get(name)).value);
    }

    static boolean hasIPv6(String name) {
        DNSResolverCache.clear(name);
        return cache6.containsKey(name) || alias.containsKey(name) && DNSResolverCache.hasIPv6((String)((Entry)alias.get(name)).value);
    }

    private static Set<InetAddress> getAddresses(String name, Map<String, Set<Entry<InetAddress>>> cache) {
        if (cache.containsKey(name)) {
            HashSet<InetAddress> out = new HashSet<InetAddress>();
            for (Entry<InetAddress> e : cache.get(name)) {
                out.add((InetAddress)((Entry)e).value);
            }
            return out;
        }
        if (alias.containsKey(name)) {
            return DNSResolverCache.getAddresses((String)((Entry)alias.get(name)).value, cache);
        }
        return null;
    }

    static void addAEntry(String name, DNSResourceRecord record) {
        DNSResolverCache.clear(name);
        if (!cache4.containsKey(name)) {
            cache4.put(name, new HashSet());
        }
        cache4.get(name).add(new Entry(((DNSA)record.getData()).getAddress(), record.getTtl()));
    }

    static void addAAAAEntry(String name, DNSResourceRecord record) {
        DNSResolverCache.clear(name);
        if (!cache6.containsKey(name)) {
            cache6.put(name, new HashSet());
        }
        cache6.get(name).add(new Entry(((DNSAAAA)record.getData()).getAddress(), record.getTtl()));
    }

    static void addCNAMEEntry(String name, DNSResourceRecord record) {
        alias.put(name, new Entry(((DNSCNAME)record.getData()).getCname(), record.getTtl()));
    }

    private static void clear(String name) {
        DNSResolverCache.clear(name, cache4);
        DNSResolverCache.clear(name, cache6);
        if (alias.containsKey(name) && !((Entry)DNSResolverCache.alias.get(name)).isValid()) {
            alias.remove(name);
        }
    }

    private static void clear(String name, Map<String, Set<Entry<InetAddress>>> cache) {
        if (cache.containsKey(name)) {
            Iterator<Entry<InetAddress>> it = cache.get(name).iterator();
            while (it.hasNext()) {
                if (((Entry)it.next()).isValid()) continue;
                it.remove();
            }
        }
    }

    private static class Entry<Value> {
        private Value value;
        private long endLive;

        private Entry(Value value, long ttl) {
            this.value = value;
            this.endLive = (System.currentTimeMillis() / 1000L + ttl) * 1000L;
        }

        private boolean isValid() {
            return System.currentTimeMillis() < this.endLive;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return e.value.equals(e) && e.endLive == this.endLive;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode() * 7 + (int)this.endLive;
        }
    }
}

