/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.Serializable;
import me.melchor9000.net.resolver.DNSResourceData;
import me.melchor9000.net.resolver.DNSUtils;

public class DNSResourceRecord
extends Serializable {
    private String name;
    private int type;
    private int nclass;
    private long ttl;
    private DNSResourceData data;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeAsString() {
        return DNSUtils.typeToString(this.type);
    }

    public void setType(String type) {
        this.type = DNSUtils.typeToInt(type);
    }

    public int getClass_() {
        return this.nclass;
    }

    public void setClass(int mclass) {
        this.nclass = mclass;
    }

    public String getClassAsString() {
        return DNSUtils.classToString(this.type);
    }

    public void setClass(String type) {
        this.type = DNSUtils.classToInt(type);
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public DNSResourceData getData() {
        return this.data;
    }

    public void setData(DNSResourceData data) {
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        this.data = data;
    }

    @Override
    public int byteBufSize() {
        return this.name.length() + 12 + (this.data != null ? this.data.byteBufSize() : 0);
    }

    @Override
    public void toByteBuf(ByteBuf buffer) {
        DNSUtils.writeName(buffer, this.name);
        buffer.writeShort(this.type);
        buffer.writeShort(this.nclass);
        buffer.writeInt((int)this.ttl);
        buffer.writeShort(this.data != null ? this.data.byteBufSize() : 0);
        if (this.data != null) {
            this.data.toByteBuf(buffer);
        }
    }

    @Override
    public void fromByteBuf(ByteBuf buffer) throws DataNotRepresentsObject {
        this.name = DNSUtils.readName(buffer);
        this.type = this.rs(buffer);
        this.nclass = this.rs(buffer);
        if (buffer.readableBytes() < 4) {
            throw new DataNotRepresentsObject("Incomplete", buffer);
        }
        this.ttl = buffer.readUnsignedInt();
        this.data = DNSResourceData.forData(this.type, buffer);
    }

    public String toString() {
        return "[" + DNSUtils.classToString(this.nclass) + "] " + DNSUtils.typeToString(this.type) + " " + this.name + " - " + this.ttl + " - " + this.data;
    }

    private int rs(ByteBuf buf) {
        if (buf.readableBytes() < 2) {
            throw new DataNotRepresentsObject("Is an incomplete DNS Resource Record", buf);
        }
        return buf.readUnsignedShort();
    }
}

