/*
 * Decompiled with CFR 0.152.
 */
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.IOService;
import me.melchor9000.net.TCPSocket;

public class TestTCP {
    private static JTextPane resultado;

    public static void main(String ... args) throws Throwable {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screenSize.getWidth();
        int height = (int)screenSize.getHeight();
        JFrame ventanica = new JFrame("HTTP test");
        ventanica.setBounds((width - 500) / 2, (height - 400) / 2, 500, 400);
        resultado = new JTextPane();
        resultado.setEditable(true);
        resultado.setContentType("text/txt");
        resultado.setEditable(false);
        final JTextField direccion = new JTextField();
        JScrollPane scrollPane = new JScrollPane(resultado);
        final JLabel bytesSentLabel = new JLabel("Bytes Sent: 0B");
        final JLabel bytesReceivedLabel = new JLabel("Bytes Received: 0B");
        final JLabel timeSpent = new JLabel("Time: 0ms");
        timeSpent.setHorizontalAlignment(0);
        JPanel bottomPanel = new JPanel(new BorderLayout(1, 3));
        bottomPanel.add((Component)bytesSentLabel, "West");
        bottomPanel.add((Component)timeSpent, "Center");
        bottomPanel.add((Component)bytesReceivedLabel, "East");
        ventanica.setLayout(new BorderLayout(3, 1));
        ventanica.add((Component)direccion, "North");
        ventanica.add((Component)scrollPane, "Center");
        ventanica.add((Component)bottomPanel, "South");
        ventanica.setDefaultCloseOperation(3);
        ventanica.setVisible(true);
        final IOService service = new IOService();
        direccion.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String host;
                int puerto;
                String path;
                TCPSocket socket;
                block4: {
                    socket = new TCPSocket(service);
                    resultado.setText("");
                    bytesSentLabel.setText("Bytes Sent: 0B");
                    bytesReceivedLabel.setText("Bytes Received: 0B");
                    timeSpent.setText("Time: 0ms");
                    direccion.setEnabled(false);
                    String addr = direccion.getText();
                    path = "/";
                    puerto = 80;
                    try {
                        URL url = new URL((addr.startsWith("http://") ? "" : "http://") + addr);
                        host = url.getHost();
                        path = url.getPath().isEmpty() ? "/" : url.getPath();
                        puerto = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
                    }
                    catch (MalformedURLException e1) {
                        String[] as = addr.split(":");
                        host = as[0];
                        if (as.length <= 1) break block4;
                        puerto = Integer.parseInt(as[1]);
                    }
                }
                final String request = "GET " + path + " HTTP/1.1\r\nAccept-Charset: utf-8\r\nUser-Agent: JavaNettyMelchor629\r\nHost: " + host + "\r\nConnection: close\r\n\r\n";
                Callback<Future<Void>> l = new Callback<Future<Void>>(){

                    @Override
                    public void call(Future<Void> arg) {
                        final long start = System.currentTimeMillis();
                        final ByteBuf b = ByteBufAllocator.DEFAULT.buffer(16384).retain();
                        socket.onClose().whenDone(new Callback<Future<Void>>(){

                            @Override
                            public void call(Future<Void> arg) {
                                direccion.setEnabled(true);
                                long spent = System.currentTimeMillis() - start;
                                timeSpent.setText(String.format("Time spent: %dms", spent));
                                b.release();
                            }
                        });
                        socket.setOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000);
                        socket.setOption(ChannelOption.SO_TIMEOUT, 5000);
                        socket.sendAsync(ByteBufUtil.writeUtf8((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharSequence)request)).whenDone(new Callback<Future<Void>>(){

                            @Override
                            public void call(Future<Void> arg) {
                                bytesSentLabel.setText("Bytes Sent: " + socket.sendBytes() + "B");
                                Callback<Future<Long>> cbk = new Callback<Future<Long>>(){

                                    @Override
                                    public void call(Future<Long> arg) {
                                        bytesReceivedLabel.setText("Bytes Received: " + socket.receivedBytes() + "B");
                                        if (!arg.isSuccessful()) {
                                            return;
                                        }
                                        byte[] b1 = new byte[(int)arg.getValueNow().longValue()];
                                        b.getBytes(0, b1);
                                        resultado.setText(resultado.getText() + new String(b1).replace("\r", "\\r").replace("\n", "\\n\n") + "");
                                        b.setIndex(0, 0);
                                        socket.receiveAsync(b).whenDone(this);
                                    }
                                };
                                socket.receiveAsync(b).whenDone(cbk);
                            }
                        });
                    }
                };
                try {
                    socket.connectAsync(host, puerto).whenDone(l);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        ventanica.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                service.cancel();
            }
        });
    }
}

