/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.channel.socket.SocketChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.melchor9000.net.IOService;
import me.melchor9000.net.SSLSocket;
import me.melchor9000.net.TCPAcceptor;
import me.melchor9000.net.TCPSocket;

public class SSLAcceptor
extends TCPAcceptor {
    private File publicKeyFile;
    private File privateKeyFile;
    private InputStream publicKeyInputStream;
    private InputStream privateKeyInputStream;
    private String passwd;

    public SSLAcceptor(IOService service, File publicKey, File privateKey) {
        this(service, publicKey, privateKey, null);
    }

    public SSLAcceptor(IOService service, InputStream publicKey, InputStream privateKey) {
        this(service, publicKey, privateKey, null);
    }

    public SSLAcceptor(IOService service, File publicKey, File privateKey, String password) {
        super(service);
        if (publicKey == null || !publicKey.isFile()) {
            throw new IllegalArgumentException("publicKey cannot be null and must exist");
        }
        if (privateKey == null || !privateKey.isFile()) {
            throw new IllegalArgumentException("privateKey cannot be null and must exist");
        }
        this.publicKeyFile = publicKey;
        this.privateKeyFile = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(IOService service, InputStream publicKey, InputStream privateKey, String password) {
        super(service);
        this.publicKeyInputStream = publicKey;
        this.privateKeyInputStream = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(IOService service, IOService worker, File publicKey, File privateKey) {
        this(service, worker, publicKey, privateKey, null);
    }

    public SSLAcceptor(IOService service, IOService worker, InputStream publicKey, InputStream privateKey) {
        this(service, worker, publicKey, privateKey, null);
    }

    public SSLAcceptor(IOService service, IOService worker, File publicKey, File privateKey, String password) {
        super(service, worker);
        if (publicKey == null || !publicKey.isFile()) {
            throw new IllegalArgumentException("publicKey cannot be null and must exist");
        }
        if (privateKey == null || !privateKey.isFile()) {
            throw new IllegalArgumentException("privateKey cannot be null and must exist");
        }
        this.publicKeyFile = publicKey;
        this.privateKeyFile = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(IOService service, IOService worker, InputStream publicKey, InputStream privateKey, String password) {
        super(service, worker);
        this.publicKeyInputStream = publicKey;
        this.privateKeyInputStream = privateKey;
        this.passwd = password;
    }

    @Override
    protected TCPSocket createSocketForImplementation(SocketChannel ch) throws IOException {
        if (this.publicKeyFile != null) {
            return new SSLSocket(this, ch, this.publicKeyFile, this.privateKeyFile, this.passwd);
        }
        if (this.publicKeyInputStream != null) {
            return new SSLSocket(this, ch, this.publicKeyInputStream, this.privateKeyInputStream, this.passwd);
        }
        throw new IllegalStateException("Unreachable code, reached :(");
    }
}

